/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.commands;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.commands.DataTable;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBlock;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamInvite;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamMission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamPermission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamReward;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSpawners;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamTrust;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamWarp;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.ConfirmationGUI;
import com.iridium.iridiumskyblock.managers.DatabaseManager;
import com.iridium.iridiumskyblock.managers.tablemanagers.ForeignIslandTableManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ClearDataCommand
extends Command<Island, User> {
    public ClearDataCommand() {
        super(Collections.singletonList("cleardata"), "Deletes data from database", "%prefix% &7/is cleardata <table> <team> --skip-confirm", "iridiumSkyblock.clearData", 10L);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, IridiumTeams<Island, User> iridiumTeams) {
        DataTable table = DataTable.ALL;
        boolean skipConfirmation = false;
        Optional<Island> island = Optional.empty();
        if (args.length == 0 || Arrays.stream(DataTable.values()).noneMatch(dataTable -> dataTable.name().equalsIgnoreCase(args[0]))) {
            sender.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
            return false;
        }
        switch (args.length) {
            case 2: {
                if (!args[1].equalsIgnoreCase("--skip-confirm") && !(island = IridiumSkyblock.getInstance().getIslandManager().getTeamViaNameOrPlayer(args[1])).isPresent()) {
                    sender.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().teamDoesntExistByName.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
                    return false;
                }
            }
            case 1: {
                try {
                    if (!Arrays.stream(DataTable.values()).anyMatch(dataTable -> dataTable.name().equalsIgnoreCase(args[0]))) break;
                    table = DataTable.valueOf(args[0]);
                    break;
                }
                catch (IllegalArgumentException e) {
                    IridiumSkyblock.getInstance().getLogger().warning(e.getMessage());
                    return false;
                }
            }
        }
        if (Arrays.stream(args).anyMatch(argument -> argument.equalsIgnoreCase("--skip-confirm"))) {
            skipConfirmation = true;
        }
        if (sender instanceof Player && !skipConfirmation) {
            this.confirmDataDeletion((Player)sender, island, table);
            return true;
        }
        this.deleteData(sender, island, table);
        return true;
    }

    private void confirmDataDeletion(Player player, Optional<Island> island, DataTable table) {
        String islandName = "ALL";
        if (island.isPresent()) {
            islandName = island.get().getName() + " (" + island.get().getOwner().get().getName() + ")";
        }
        player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().confirmDataDeletion.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix).replace("%table%", table.name()).replace("%island%", islandName)));
        player.openInventory(new ConfirmationGUI<Island, User>(() -> this.deleteData((CommandSender)player, island, table), IridiumSkyblock.getInstance()).getInventory());
    }

    private CompletableFuture<Void> deleteData(CommandSender sender, Optional<Island> island, DataTable table) {
        return CompletableFuture.runAsync(() -> {
            if (!this.backupDatabaseFile()) {
                return;
            }
            List<Object> islands = new ArrayList<Island>();
            if (!island.isPresent()) {
                islands = IridiumSkyblock.getInstance().getIslandManager().getTeams();
            } else {
                islands.add((Island)island.get());
            }
            boolean all = table == DataTable.ALL;
            DatabaseManager databaseManager = IridiumSkyblock.getInstance().getDatabaseManager();
            try {
                switch (table) {
                    case ALL: 
                    case ISLAND: {
                        databaseManager.getIslandTableManager().delete(islands).join();
                        if (!all) break;
                    }
                    case INVITE: {
                        ForeignIslandTableManager<String, TeamInvite> inviteTableManager = databaseManager.getInvitesTableManager();
                        for (Island island2 : islands) {
                            for (TeamInvite teamInvite : inviteTableManager.getEntries(island2)) {
                                inviteTableManager.delete(teamInvite).join();
                            }
                        }
                        if (!all) break;
                    }
                    case TRUST: {
                        ForeignIslandTableManager<String, TeamTrust> trustTableManager = databaseManager.getTrustTableManager();
                        for (Island island3 : islands) {
                            for (TeamTrust teamTrust : trustTableManager.getEntries(island3)) {
                                trustTableManager.delete(teamTrust).join();
                            }
                        }
                        if (!all) break;
                    }
                    case PERMISSION: {
                        ForeignIslandTableManager<String, TeamPermission> permissionTableManager = databaseManager.getPermissionsTableManager();
                        for (Island island4 : islands) {
                            for (TeamPermission teamPermission : permissionTableManager.getEntries(island4)) {
                                permissionTableManager.delete(teamPermission).join();
                            }
                        }
                        if (!all) break;
                    }
                    case BANK: {
                        ForeignIslandTableManager<String, TeamBank> bankTableManager = databaseManager.getBankTableManager();
                        for (Island island5 : islands) {
                            for (TeamBank teamBank : bankTableManager.getEntries(island5)) {
                                bankTableManager.delete(teamBank).join();
                            }
                        }
                        if (!all) break;
                    }
                    case ENHANCEMENT: {
                        ForeignIslandTableManager<String, TeamEnhancement> enhancementTableManager = databaseManager.getEnhancementTableManager();
                        for (Island island6 : islands) {
                            for (TeamEnhancement teamEnhancement : enhancementTableManager.getEntries(island6)) {
                                enhancementTableManager.delete(teamEnhancement).join();
                            }
                        }
                        if (!all) break;
                    }
                    case TEAM_BLOCK: {
                        ForeignIslandTableManager<String, TeamBlock> blockTableManager = databaseManager.getTeamBlockTableManager();
                        for (Island island7 : islands) {
                            for (TeamBlock teamBlock : blockTableManager.getEntries(island7)) {
                                blockTableManager.delete(teamBlock).join();
                            }
                        }
                        if (!all) break;
                    }
                    case TEAM_SPAWNER: {
                        ForeignIslandTableManager<String, TeamSpawners> spawnerTableManager = databaseManager.getTeamSpawnerTableManager();
                        for (Island island8 : islands) {
                            for (TeamSpawners teamSpawners : spawnerTableManager.getEntries(island8)) {
                                spawnerTableManager.delete(teamSpawners).join();
                            }
                        }
                        if (!all) break;
                    }
                    case TEAM_WARP: {
                        ForeignIslandTableManager<String, TeamWarp> warpTableManager = databaseManager.getTeamWarpTableManager();
                        for (Island island9 : islands) {
                            for (TeamWarp teamWarp : warpTableManager.getEntries(island9)) {
                                warpTableManager.delete(teamWarp).join();
                            }
                        }
                        if (!all) break;
                    }
                    case TEAM_MISSION: {
                        ForeignIslandTableManager<String, TeamMission> missionTableManager = databaseManager.getTeamMissionTableManager();
                        for (Island island10 : islands) {
                            for (TeamMission teamMission : missionTableManager.getEntries(island10)) {
                                IridiumSkyblock.getInstance().getIslandManager().deleteTeamMission(teamMission);
                                IridiumSkyblock.getInstance().getIslandManager().deleteTeamMissionData(teamMission);
                            }
                        }
                        if (!all) break;
                    }
                    case TEAM_REWARDS: {
                        ForeignIslandTableManager<String, TeamReward> rewardTableManager = databaseManager.getTeamRewardsTableManager();
                        for (Island island11 : islands) {
                            for (TeamReward teamReward : rewardTableManager.getEntries(island11)) {
                                rewardTableManager.delete(teamReward).join();
                            }
                        }
                        if (!all) break;
                    }
                    case TEAM_SETTINGS: {
                        ForeignIslandTableManager<String, TeamSetting> settingTableManager = databaseManager.getTeamSettingsTableManager();
                        for (Island island12 : islands) {
                            for (TeamSetting teamSetting : settingTableManager.getEntries(island12)) {
                                settingTableManager.delete(teamSetting).join();
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                IridiumSkyblock.getInstance().getLogger().warning(e.getMessage());
                return;
            }
            sender.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().dataDeletion.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
        });
    }

    private boolean backupDatabaseFile() {
        IridiumSkyblock.getInstance().getLogger().info("Creating a backup for IridiumSkyblock.db in \"backups\" folder...");
        File pluginFolder = new File(IridiumSkyblock.getInstance().getDataFolder().getPath());
        File file = new File(pluginFolder + File.separator + "IridiumSkyblock.db");
        File backupFolder = new File(pluginFolder.getPath() + File.separator + "backups");
        File backupDatabaseFile = new File(backupFolder + File.separator + file.getName());
        try {
            if (!backupFolder.exists()) {
                backupFolder.mkdir();
            }
            Files.copy(file.toPath(), backupDatabaseFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            IridiumSkyblock.getInstance().getLogger().info("Success! Backup \"IridiumSkyblock.db\" created, check \"" + backupFolder.getPath() + "\".");
            return true;
        }
        catch (IOException exception) {
            IridiumSkyblock.getInstance().getLogger().severe("Failed to move \"IridiumSkyblock.db\" to " + backupFolder + ": " + exception.getMessage());
            return false;
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<Island, User> iridiumTeams) {
        switch (args.length) {
            case 1: {
                ArrayList<String> tables = new ArrayList<String>();
                for (DataTable table : DataTable.values()) {
                    tables.add(table.name());
                }
                return tables;
            }
            case 2: {
                List<String> fullTabComplete = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                fullTabComplete.add("--skip-confirm");
                return fullTabComplete;
            }
            case 3: {
                return Collections.singletonList("--skip-confirm");
            }
        }
        return Collections.emptyList();
    }
}

