/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumcore;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.MinecraftVersion;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.Persist;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.GUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.multiversion.IridiumInventory;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.multiversion.MultiVersion;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.nms.NMS;
import com.iridium.iridiumskyblock.dependencies.lib.PaperLib;
import java.io.File;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitTask;

public class IridiumCore
extends JavaPlugin {
    private Persist persist;
    private NMS nms;
    private MultiVersion multiVersion;
    private IridiumInventory iridiumInventory;
    private static boolean testing = false;
    private BukkitTask saveTask;
    private static IridiumCore instance;

    public IridiumCore(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        IridiumCore.setTesting(true);
        this.getLogger().setFilter(record -> false);
    }

    public void onLoad() {
        instance = this;
        this.getDataFolder().mkdir();
        this.persist = new Persist(Persist.PersistType.YAML, this);
        this.loadConfigs();
        this.saveConfigs();
    }

    public void onEnable() {
        this.setupMultiVersion();
        if (!PaperLib.isSpigot() && !IridiumCore.isTesting()) {
            this.getLogger().warning("CraftBukkit isn't supported, please use spigot or one of its forks");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerListeners();
        if (IridiumCore.isTesting()) {
            return;
        }
        this.saveTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::saveData, 0L, 6000L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> Bukkit.getServer().getOnlinePlayers().forEach(player -> {
            InventoryHolder inventoryHolder = this.iridiumInventory.getTopInventory((Player)player).getHolder();
            if (inventoryHolder instanceof GUI) {
                ((GUI)inventoryHolder).addContent(this.iridiumInventory.getTopInventory((Player)player));
            }
        }), 0L, 1L);
    }

    public void onDisable() {
        if (IridiumCore.isTesting()) {
            return;
        }
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        this.saveData();
        Bukkit.getOnlinePlayers().forEach(HumanEntity::closeInventory);
        this.getLogger().info("-------------------------------");
        this.getLogger().info("");
        this.getLogger().info(this.getDescription().getName() + " Disabled!");
        this.getLogger().info("");
        this.getLogger().info("-------------------------------");
    }

    public void registerListeners() {
    }

    public void saveData() {
    }

    private void setupMultiVersion() {
        if (Bukkit.getVersion().contains("1.20.5") || Bukkit.getVersion().contains("1.20.6")) {
            this.nms = MinecraftVersion.V1_20_R4.getNms();
            this.multiVersion = MinecraftVersion.V1_20_R4.getMultiVersion(this);
            this.iridiumInventory = MinecraftVersion.V1_20_R4.getInventory();
            return;
        }
        try {
            String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            MinecraftVersion minecraftVersion = MinecraftVersion.byName(version);
            this.nms = minecraftVersion.getNms();
            this.multiVersion = minecraftVersion.getMultiVersion(this);
            this.iridiumInventory = minecraftVersion.getInventory();
        }
        catch (Exception exception) {
            this.nms = MinecraftVersion.DEFAULT.getNms();
            this.multiVersion = MinecraftVersion.DEFAULT.getMultiVersion(this);
            this.iridiumInventory = MinecraftVersion.DEFAULT.getInventory();
        }
    }

    public void loadConfigs() {
    }

    public void saveConfigs() {
    }

    public static IridiumCore getInstance() {
        return instance;
    }

    @Generated
    public Persist getPersist() {
        return this.persist;
    }

    @Generated
    public NMS getNms() {
        return this.nms;
    }

    @Generated
    public MultiVersion getMultiVersion() {
        return this.multiVersion;
    }

    @Generated
    public IridiumInventory getIridiumInventory() {
        return this.iridiumInventory;
    }

    @Generated
    public BukkitTask getSaveTask() {
        return this.saveTask;
    }

    @Generated
    public IridiumCore() {
    }

    @Generated
    public static void setTesting(boolean testing) {
        IridiumCore.testing = testing;
    }

    @Generated
    public static boolean isTesting() {
        return testing;
    }
}

