/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumcore.utils;

import com.iridium.iridiumskyblock.dependencies.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class NumberFormatter {
    public int numberAbbreviationDecimalPlaces = 2;
    public String thousandAbbreviation = "K";
    public String millionAbbreviation = "M";
    public String billionAbbreviation = "B";
    public String trillionAbbreviation = "T";
    public boolean displayNumberAbbreviations = true;
    @JsonIgnore
    private final BigDecimal ONE_THOUSAND = new BigDecimal(1000L);
    @JsonIgnore
    private final BigDecimal ONE_MILLION = new BigDecimal(1000000L);
    @JsonIgnore
    private final BigDecimal ONE_BILLION = new BigDecimal(1000000000L);
    @JsonIgnore
    private final BigDecimal ONE_TRILLION = new BigDecimal(1000000000000L);

    public String format(double number) {
        if (this.displayNumberAbbreviations) {
            return this.formatNumber(BigDecimal.valueOf(number));
        }
        return String.format("%." + this.numberAbbreviationDecimalPlaces + "f", number);
    }

    private String formatNumber(BigDecimal bigDecimal) {
        bigDecimal = bigDecimal.setScale(this.numberAbbreviationDecimalPlaces, RoundingMode.HALF_DOWN);
        StringBuilder outputStringBuilder = new StringBuilder();
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            outputStringBuilder.append("-").append(this.formatNumber(bigDecimal.negate()));
        } else if (bigDecimal.compareTo(this.ONE_THOUSAND) < 0) {
            outputStringBuilder.append(bigDecimal.stripTrailingZeros().toPlainString());
        } else if (bigDecimal.compareTo(this.ONE_MILLION) < 0) {
            outputStringBuilder.append(bigDecimal.divide(this.ONE_THOUSAND, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString()).append(this.thousandAbbreviation);
        } else if (bigDecimal.compareTo(this.ONE_BILLION) < 0) {
            outputStringBuilder.append(bigDecimal.divide(this.ONE_MILLION, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString()).append(this.millionAbbreviation);
        } else if (bigDecimal.compareTo(this.ONE_TRILLION) < 0) {
            outputStringBuilder.append(bigDecimal.divide(this.ONE_BILLION, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString()).append(this.billionAbbreviation);
        } else {
            outputStringBuilder.append(bigDecimal.divide(this.ONE_TRILLION, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString()).append(this.trillionAbbreviation);
        }
        return outputStringBuilder.toString();
    }
}

