/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumcore.utils;

import com.iridium.iridiumskyblock.dependencies.iridiumcolorapi.IridiumColorAPI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.DefaultFontInfo;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import java.util.List;
import java.util.stream.Collectors;

public class StringUtils {
    private static final int CENTER_PX = 154;

    public static String color(String string) {
        return IridiumColorAPI.process(string);
    }

    public static List<String> color(List<String> strings) {
        return strings.stream().map(StringUtils::color).collect(Collectors.toList());
    }

    public static List<String> processMultiplePlaceholders(List<String> lines, List<Placeholder> placeholders) {
        return lines.stream().map(s -> StringUtils.processMultiplePlaceholders(s, placeholders)).collect(Collectors.toList());
    }

    public static String processMultiplePlaceholders(String line, List<Placeholder> placeholders) {
        String processedLine = line;
        for (Placeholder placeholder : placeholders) {
            processedLine = placeholder.process(processedLine);
        }
        return StringUtils.color(processedLine);
    }

    public static String getCenteredMessage(String message, String buffer) {
        if (message == null || message.equals("")) {
            return "";
        }
        message = StringUtils.color(message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(StringUtils.color(buffer));
        }
        return sb + message + sb;
    }
}

