/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams;

import com.iridium.iridiumskyblock.dependencies.bstats.bukkit.Metrics;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.IridiumCore;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.ChatType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Permission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PlaceholderBuilder;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Setting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.SettingType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.TeamChatPlaceholderBuilder;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.UserRank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.BankItems;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.BlockValues;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Commands;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Configuration;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Enhancements;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Inventories;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Messages;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Missions;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Permissions;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Settings;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Shop;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Top;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.dependencies.updatechecker.UpdateCheckSource;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.dependencies.updatechecker.UpdateChecker;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.PotionEnhancementData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockBreakListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockBurnListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockExplodeListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockFertilizeListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockFormListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockFromToListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockGrowListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockPistonListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockPlaceListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.BlockSpreadListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.EnchantItemListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.EntityChangeBlockListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.EntityDamageListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.EntityDeathListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.EntityExplodeListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.EntityInteractListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.EntitySpawnListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.FurnaceSmeltListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.InventoryClickListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.InventoryCloseListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.LeavesDecayListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerBucketListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerChatListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerCraftListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerExpChangeListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerFishListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerInteractListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerJoinListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerMoveListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PlayerTeleportListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.PotionBrewListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.SettingUpdateListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.SpawnerSpawnListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.StructureGrowListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.TeamLevelUpListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners.TeleportListener;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.CommandManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.IridiumUserManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.MissionManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.ShopManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.SupportManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.TeamManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.placeholders.ClipPlaceholderAPI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.sorting.TeamSorting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPluginLoader;

public abstract class IridiumTeams<T extends Team, U extends IridiumUser<T>>
extends IridiumCore {
    private final Map<Integer, UserRank> userRanks = new HashMap<Integer, UserRank>();
    private final Map<String, Permission> permissionList = new HashMap<String, Permission>();
    private final Map<String, Setting> settingsList = new HashMap<String, Setting>();
    private final Map<String, Enhancement<?>> enhancementList = new HashMap();
    private final List<BankItem> bankItemList = new ArrayList<BankItem>();
    private final List<ChatType> chatTypes = new ArrayList<ChatType>();
    private final List<TeamSorting<T>> sortingTypes = new ArrayList<TeamSorting<T>>();
    private boolean recalculating = false;

    public IridiumTeams(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.initializePermissions();
        this.initializeSettings();
        this.initializeBankItem();
        this.initializeChatTypes();
        this.initializeEnhancements();
        this.initializeSortingTypes();
        this.recalculateTeams();
        this.registerPlaceholderSupport();
        this.getLogger().info("-------------------------------");
        this.getLogger().info("");
        this.getLogger().info(this.getDescription().getName() + " Enabled!");
        this.getLogger().info("");
        this.getLogger().info("-------------------------------");
    }

    @Override
    public void onDisable() {
        this.saveData();
        Bukkit.getOnlinePlayers().forEach(HumanEntity::closeInventory);
        this.getLogger().info("-------------------------------");
        this.getLogger().info("");
        this.getLogger().info(this.getDescription().getName() + " Disabled!");
        this.getLogger().info("");
        this.getLogger().info("-------------------------------");
    }

    private void registerPlaceholderSupport() {
        ClipPlaceholderAPI clipPlaceholderAPI;
        Plugin PlaceholderAPI = this.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        if (PlaceholderAPI != null && PlaceholderAPI.isEnabled() && (clipPlaceholderAPI = new ClipPlaceholderAPI(this)).register()) {
            this.getLogger().info("Successfully registered Placeholders for PlaceholderAPI.");
        }
    }

    public abstract Economy getEconomy();

    public abstract PlaceholderBuilder<T> getTeamsPlaceholderBuilder();

    public abstract PlaceholderBuilder<U> getUserPlaceholderBuilder();

    public abstract TeamChatPlaceholderBuilder getTeamChatPlaceholderBuilder();

    public abstract TeamManager<T, U> getTeamManager();

    public abstract IridiumUserManager<T, U> getUserManager();

    public abstract TeleportManager<T, U> getTeleportManager();

    public abstract CommandManager<T, U> getCommandManager();

    public abstract MissionManager<T, U> getMissionManager();

    public abstract ShopManager<T, U> getShopManager();

    public abstract SupportManager<T, U> getSupportManager();

    public abstract Configuration getConfiguration();

    public abstract Messages getMessages();

    public abstract Permissions getPermissions();

    public abstract Inventories getInventories();

    public abstract Enhancements getEnhancements();

    public abstract Commands<T, U> getCommands();

    public abstract BlockValues getBlockValues();

    public abstract Top<T> getTop();

    public abstract BankItems getBankItems();

    public abstract Missions getMissions();

    public abstract Shop getShop();

    public abstract Settings getSettings();

    public void recalculateTeams() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, new Runnable(){
            ListIterator<Integer> teams;
            boolean locked;
            int counter;
            {
                this.teams = IridiumTeams.this.getTeamManager().getTeams().stream().map(Team::getId).collect(Collectors.toList()).listIterator();
                this.locked = false;
                this.counter = 0;
            }

            @Override
            public void run() {
                int interval;
                ++this.counter;
                int n = interval = IridiumTeams.this.recalculating ? IridiumTeams.this.getConfiguration().forceRecalculateInterval : IridiumTeams.this.getConfiguration().recalculateInterval;
                if (this.counter % interval == 0) {
                    if (this.locked) {
                        return;
                    }
                    if (!this.teams.hasNext()) {
                        this.teams = IridiumTeams.this.getTeamManager().getTeams().stream().map(Team::getId).collect(Collectors.toList()).listIterator();
                        if (IridiumTeams.this.recalculating) {
                            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                                if (!player.hasPermission(IridiumTeams.this.getCommands().recalculateCommand.permission)) continue;
                                player.sendMessage(StringUtils.color(IridiumTeams.this.getMessages().calculatingFinished.replace("%prefix%", IridiumTeams.this.getConfiguration().prefix)));
                            }
                        }
                        IridiumTeams.this.recalculating = false;
                    } else {
                        IridiumTeams.this.getTeamManager().getTeamViaID(this.teams.next()).ifPresent(team -> {
                            this.locked = true;
                            IridiumTeams.this.getTeamManager().recalculateTeam((Team)team).whenComplete((result, exception) -> {
                                this.locked = false;
                            });
                        });
                    }
                }
            }
        }, 0L, 0L);
    }

    @Override
    public void registerListeners() {
        Bukkit.getPluginManager().registerEvents(new BlockBreakListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockBurnListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockExplodeListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockFertilizeListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockFormListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockFromToListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockGrowListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockPistonListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockPlaceListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new BlockSpreadListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new EnchantItemListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new EntityChangeBlockListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new EntityDeathListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new EntityExplodeListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new EntityInteractListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new EntitySpawnListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new FurnaceSmeltListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryCloseListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new LeavesDecayListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerChatListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerCraftListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerExpChangeListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerFishListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerJoinListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerMoveListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerTeleportListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerInteractListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PotionBrewListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new SpawnerSpawnListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new StructureGrowListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new TeamLevelUpListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new SettingUpdateListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new EntityDamageListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new PlayerBucketListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new TeleportListener(this), (Plugin)this);
    }

    @Override
    public void saveData() {
    }

    @Override
    public void loadConfigs() {
        this.userRanks.putAll(this.getConfiguration().userRanks);
        this.userRanks.put(Rank.VISITOR.getId(), this.getConfiguration().visitor);
        this.userRanks.put(Rank.OWNER.getId(), this.getConfiguration().owner);
    }

    @Override
    public void saveConfigs() {
    }

    public void initializePermissions() {
        this.addPermission(PermissionType.BLOCK_BREAK.getPermissionKey(), this.getPermissions().blockBreak);
        this.addPermission(PermissionType.BLOCK_PLACE.getPermissionKey(), this.getPermissions().blockPlace);
        this.addPermission(PermissionType.BUCKET.getPermissionKey(), this.getPermissions().bucket);
        this.addPermission(PermissionType.CHANGE_PERMISSIONS.getPermissionKey(), this.getPermissions().changePermissions);
        this.addPermission(PermissionType.CLAIM.getPermissionKey(), this.getPermissions().claim);
        this.addPermission(PermissionType.DEMOTE.getPermissionKey(), this.getPermissions().demote);
        this.addPermission(PermissionType.DESCRIPTION.getPermissionKey(), this.getPermissions().description);
        this.addPermission(PermissionType.DOORS.getPermissionKey(), this.getPermissions().doors);
        this.addPermission(PermissionType.INVITE.getPermissionKey(), this.getPermissions().invite);
        this.addPermission(PermissionType.TRUST.getPermissionKey(), this.getPermissions().trust);
        this.addPermission(PermissionType.KICK.getPermissionKey(), this.getPermissions().kick);
        this.addPermission(PermissionType.KILL_MOBS.getPermissionKey(), this.getPermissions().killMobs);
        this.addPermission(PermissionType.OPEN_CONTAINERS.getPermissionKey(), this.getPermissions().openContainers);
        this.addPermission(PermissionType.PROMOTE.getPermissionKey(), this.getPermissions().promote);
        this.addPermission(PermissionType.REDSTONE.getPermissionKey(), this.getPermissions().redstone);
        this.addPermission(PermissionType.RENAME.getPermissionKey(), this.getPermissions().rename);
        this.addPermission(PermissionType.SETHOME.getPermissionKey(), this.getPermissions().setHome);
        this.addPermission(PermissionType.SPAWNERS.getPermissionKey(), this.getPermissions().spawners);
        this.addPermission(PermissionType.SETTINGS.getPermissionKey(), this.getPermissions().settings);
        this.addPermission(PermissionType.MANAGE_WARPS.getPermissionKey(), this.getPermissions().manageWarps);
        this.addPermission(PermissionType.INTERACT.getPermissionKey(), this.getPermissions().interact);
    }

    public void initializeSettings() {
        this.addSetting(SettingType.TEAM_TYPE.getSettingKey(), this.getSettings().teamJoining, Arrays.asList("Private", "Public"));
        this.addSetting(SettingType.VALUE_VISIBILITY.getSettingKey(), this.getSettings().teamValue, Arrays.asList("Private", "Public"));
        this.addSetting(SettingType.MOB_SPAWNING.getSettingKey(), this.getSettings().mobSpawning, Arrays.asList("Enabled", "Disabled"));
        this.addSetting(SettingType.LEAF_DECAY.getSettingKey(), this.getSettings().leafDecay, Arrays.asList("Enabled", "Disabled"));
        this.addSetting(SettingType.ICE_FORM.getSettingKey(), this.getSettings().iceForm, Arrays.asList("Enabled", "Disabled"));
        this.addSetting(SettingType.FIRE_SPREAD.getSettingKey(), this.getSettings().fireSpread, Arrays.asList("Enabled", "Disabled"));
        this.addSetting(SettingType.CROP_TRAMPLE.getSettingKey(), this.getSettings().cropTrample, Arrays.asList("Enabled", "Disabled"));
        this.addSetting(SettingType.WEATHER.getSettingKey(), this.getSettings().weather, Arrays.asList("Server", "Sunny", "Raining"));
        this.addSetting(SettingType.TIME.getSettingKey(), this.getSettings().time, Arrays.asList("Server", "Sunrise", "Day", "Morning", "Noon", "Sunset", "Night", "Midnight"));
        this.addSetting(SettingType.ENTITY_GRIEF.getSettingKey(), this.getSettings().entityGrief, Arrays.asList("Enabled", "Disabled"));
        this.addSetting(SettingType.TNT_DAMAGE.getSettingKey(), this.getSettings().tntDamage, Arrays.asList("Enabled", "Disabled"));
        this.addSetting(SettingType.TEAM_VISITING.getSettingKey(), this.getSettings().visiting, Arrays.asList("Enabled", "Disabled"));
    }

    public void initializeBankItem() {
        this.addBankItem(this.getBankItems().experienceBankItem);
        this.addBankItem(this.getBankItems().moneyBankItem);
    }

    public void initializeChatTypes() {
        this.addChatType(new ChatType(this.getConfiguration().noneChatAlias, player -> null));
        this.addChatType(new ChatType(this.getConfiguration().teamChatAlias, player -> this.getTeamManager().getTeamViaID(((IridiumUser)this.getUserManager().getUser((OfflinePlayer)player)).getTeamID()).map(t -> this.getTeamManager().getTeamMembers((Team)t).stream().map(IridiumUser::getPlayer).collect(Collectors.toList())).orElse(null)));
    }

    public void initializeEnhancements() {
        for (Map.Entry<String, Enhancement<PotionEnhancementData>> enhancement : this.getEnhancements().potionEnhancements.entrySet()) {
            this.addEnhancement(enhancement.getKey(), enhancement.getValue());
        }
        this.addEnhancement("farming", this.getEnhancements().farmingEnhancement);
        this.addEnhancement("spawner", this.getEnhancements().spawnerEnhancement);
        this.addEnhancement("experience", this.getEnhancements().experienceEnhancement);
        this.addEnhancement("flight", this.getEnhancements().flightEnhancement);
        this.addEnhancement("members", this.getEnhancements().membersEnhancement);
        this.addEnhancement("warps", this.getEnhancements().warpsEnhancement);
    }

    public void initializeSortingTypes() {
        this.addSortingType(this.getTop().experienceTeamSort);
        this.addSortingType(this.getTop().valueTeamSort);
    }

    public void addPermission(String key, Permission permission) {
        this.permissionList.put(key, permission);
    }

    public void addSetting(String key, Setting setting, List<String> values) {
        if (!setting.enabled) {
            return;
        }
        setting.setValues(values);
        this.settingsList.put(key, setting);
    }

    public void addBankItem(BankItem bankItem) {
        if (bankItem.isEnabled()) {
            this.bankItemList.add(bankItem);
        }
    }

    public void addChatType(ChatType chatType) {
        this.chatTypes.add(chatType);
    }

    public void addEnhancement(String key, Enhancement<?> enhancement) {
        if (!enhancement.enabled) {
            return;
        }
        this.enhancementList.put(key, enhancement);
    }

    public void addSortingType(TeamSorting<T> sortingType) {
        this.sortingTypes.add(sortingType);
    }

    public void addBstats(int pluginId) {
        new Metrics((Plugin)this, pluginId);
    }

    public void startUpdateChecker(int pluginId) {
        this.startUpdateChecker(String.valueOf(pluginId));
    }

    public void startUpdateChecker(String pluginId) {
        if (this.getConfiguration().updateChecks) {
            new UpdateChecker(this, UpdateCheckSource.SPIGOT, pluginId).checkEveryXHours(24.0).setDownloadLink(pluginId).setColoredConsoleOutput(true).checkNow();
        }
    }

    @Generated
    public Map<Integer, UserRank> getUserRanks() {
        return this.userRanks;
    }

    @Generated
    public Map<String, Permission> getPermissionList() {
        return this.permissionList;
    }

    @Generated
    public Map<String, Setting> getSettingsList() {
        return this.settingsList;
    }

    @Generated
    public Map<String, Enhancement<?>> getEnhancementList() {
        return this.enhancementList;
    }

    @Generated
    public List<BankItem> getBankItemList() {
        return this.bankItemList;
    }

    @Generated
    public List<ChatType> getChatTypes() {
        return this.chatTypes;
    }

    @Generated
    public List<TeamSorting<T>> getSortingTypes() {
        return this.sortingTypes;
    }

    @Generated
    public boolean isRecalculating() {
        return this.recalculating;
    }

    @Generated
    public IridiumTeams() {
    }

    @Generated
    public void setRecalculating(boolean recalculating) {
        this.recalculating = recalculating;
    }
}

