/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.SettingType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.BlockValuesTypeSelectorInventoryConfig;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.BlockValueGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.BlockValuesTypeSelectorGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.SpawnerValueGUI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BlockValueCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public BlockValueCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        BlockValuesTypeSelectorInventoryConfig blockValuesTypeSelectorInventoryConfig = iridiumTeams.getInventories().blockValuesTypeSelectorGUI;
        String teamArg = args.length > 1 ? args[0] : player.getName();
        Optional<T> team = iridiumTeams.getTeamManager().getTeamViaNameOrPlayer(teamArg);
        if (!team.isPresent() && args.length >= 1) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamDoesntExistByName.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (!team.isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().dontHaveTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        TeamSetting teamSetting = iridiumTeams.getTeamManager().getTeamSetting((Team)team.get(), SettingType.VALUE_VISIBILITY.getSettingKey());
        if (teamSetting != null && teamSetting.getValue().equalsIgnoreCase("Private") && !iridiumTeams.getTeamManager().getTeamMembers((Team)team.get()).contains(user) && !((IridiumUser)user).isBypassing()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamIsPrivate.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (args.length == 0) {
            player.openInventory(new BlockValuesTypeSelectorGUI<T, U>(teamArg, player, iridiumTeams).getInventory());
            return true;
        }
        switch (args[args.length - 1]) {
            case "blocks": {
                if (blockValuesTypeSelectorInventoryConfig.blocks.enabled) {
                    player.openInventory(new BlockValueGUI<Team, U>((Team)team.get(), player, iridiumTeams).getInventory());
                    return true;
                }
            }
            case "spawners": {
                if (!blockValuesTypeSelectorInventoryConfig.spawners.enabled) break;
                player.openInventory(new SpawnerValueGUI<Team, U>((Team)team.get(), player, iridiumTeams).getInventory());
                return true;
            }
        }
        player.openInventory(new BlockValuesTypeSelectorGUI<T, U>(teamArg, player, iridiumTeams).getInventory());
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        switch (args.length) {
            case 1: {
                return Arrays.asList("blocks", "spawners");
            }
            case 2: {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    @Generated
    public BlockValueCommand() {
    }
}

