/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.commons.lang.NotImplementedException;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.CooldownProvider;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Command<T extends Team, U extends IridiumUser<T>> {
    @NotNull
    public final List<String> aliases;
    @NotNull
    public final String description;
    @NotNull
    public final String syntax;
    @NotNull
    public final String permission;
    public final long cooldownInSeconds;
    public final boolean enabled;
    @JsonIgnore
    private CooldownProvider<CommandSender> cooldownProvider;

    public Command() {
        this.aliases = Collections.emptyList();
        this.description = "";
        this.syntax = "";
        this.permission = "";
        this.cooldownInSeconds = 0L;
        this.enabled = true;
    }

    public Command(@NotNull List<String> aliases, @NotNull String description, @NotNull String syntax, @NotNull String permission, long cooldownInSeconds) {
        this.aliases = aliases;
        this.description = description;
        this.syntax = syntax;
        this.permission = permission;
        this.cooldownInSeconds = cooldownInSeconds;
        this.enabled = true;
    }

    public CooldownProvider<CommandSender> getCooldownProvider() {
        if (this.cooldownProvider == null) {
            this.cooldownProvider = new CooldownProvider(Duration.ofSeconds(this.cooldownInSeconds));
        }
        return this.cooldownProvider;
    }

    public boolean execute(CommandSender sender, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().mustBeAPlayer.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        return this.execute(iridiumTeams.getUserManager().getUser((OfflinePlayer)sender), arguments, iridiumTeams);
    }

    public boolean execute(U user, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        Optional<T> team = iridiumTeams.getTeamManager().getTeamViaID(((IridiumUser)user).getTeamID());
        if (!team.isPresent()) {
            ((IridiumUser)user).getPlayer().sendMessage(StringUtils.color(iridiumTeams.getMessages().dontHaveTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        return this.execute(user, (Team)team.get(), arguments, iridiumTeams);
    }

    public boolean execute(U user, T team, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        throw new NotImplementedException();
    }

    public boolean hasPermission(CommandSender commandSender, IridiumTeams<T, U> iridiumTeams) {
        return commandSender.hasPermission(this.permission) || this.permission.equalsIgnoreCase("");
    }

    public boolean isOnCooldown(CommandSender commandSender, IridiumTeams<T, U> iridiumTeams) {
        if (!(commandSender instanceof Player)) {
            return false;
        }
        Player player = (Player)commandSender;
        U user = iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        return this.getCooldownProvider().isOnCooldown(commandSender) && !((IridiumUser)user).isBypassing();
    }

    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        if (commandSender instanceof Player) {
            U user = iridiumTeams.getUserManager().getUser((OfflinePlayer)commandSender);
            Optional<T> team = iridiumTeams.getTeamManager().getTeamViaID(((IridiumUser)user).getTeamID());
            if (team.isPresent()) {
                return this.onTabComplete(user, (Team)team.get(), args, iridiumTeams);
            }
        }
        return Collections.emptyList();
    }

    public List<String> onTabComplete(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        return Collections.emptyList();
    }

    @JsonIgnore
    public boolean isSuperSecretCommand() {
        return false;
    }
}

