/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.EnhancementType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.UpgradesGUI;
import java.util.List;
import lombok.Generated;
import org.bukkit.entity.Player;

public class UpgradesCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public UpgradesCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length == 0) {
            player.openInventory(new UpgradesGUI<T, U>(team, player, iridiumTeams).getInventory());
            return true;
        }
        if (args.length != 2 || !args[0].equalsIgnoreCase("buy")) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        String booster = args[1];
        Enhancement<?> enhancement = iridiumTeams.getEnhancementList().get(booster);
        if (enhancement == null || enhancement.type != EnhancementType.UPGRADE) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().noSuchUpgrade.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        TeamEnhancement teamEnhancement = iridiumTeams.getTeamManager().getTeamEnhancement(team, booster);
        if (enhancement.levels.get(teamEnhancement.getLevel() + 1) == null) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().maxUpgradeLevelReached.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        boolean success = iridiumTeams.getTeamManager().UpdateEnhancement(team, booster, player);
        if (success) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().purchasedUpgrade.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%upgrade%", booster)));
        }
        return success;
    }

    @Generated
    public UpgradesCommand() {
    }
}

