/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamWarp;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.entity.Player;

public class WarpCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public WarpCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length != 1 && args.length != 2) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        Optional<TeamWarp> teamWarp = iridiumTeams.getTeamManager().getTeamWarp(team, args[0]);
        if (!teamWarp.isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().unknownWarp.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (!(teamWarp.get().getPassword() == null || args.length == 2 && teamWarp.get().getPassword().equals(args[1]))) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().incorrectPassword.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        iridiumTeams.getTeamManager().teleportToWarp(player, teamWarp.get().getLocation(), team, teamWarp.get().getName());
        return true;
    }

    @Override
    public List<String> onTabComplete(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        List<TeamWarp> teamWarps = iridiumTeams.getTeamManager().getTeamWarps(team);
        return teamWarps.stream().map(TeamWarp::getName).collect(Collectors.toList());
    }

    @Generated
    public WarpCommand() {
    }
}

