/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.database;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.EnhancementType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseField;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.DatabaseTable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@DatabaseTable(tableName="team_enhancements")
public final class TeamEnhancement
extends TeamData {
    @DatabaseField(columnName="id", generatedId=true, canBeNull=false)
    private int id;
    @DatabaseField(columnName="enhancement_name", canBeNull=false, uniqueCombo=true)
    private String enhancementName;
    @DatabaseField(columnName="level", canBeNull=false)
    private int level;
    @DatabaseField(columnName="start_time", canBeNull=false)
    private LocalDateTime expirationTime;

    public TeamEnhancement(@NotNull Team team, String enhancementName, int level) {
        super(team);
        this.enhancementName = enhancementName;
        this.level = level;
        this.expirationTime = LocalDateTime.now();
    }

    public boolean isActive() {
        return LocalDateTime.now().until(this.expirationTime, ChronoUnit.SECONDS) > 0L;
    }

    public boolean isActive(EnhancementType enhancementType) {
        return enhancementType == EnhancementType.UPGRADE || this.isActive();
    }

    public long getRemainingTime() {
        return LocalDateTime.now().until(this.expirationTime, ChronoUnit.SECONDS);
    }

    public void setLevel(int level) {
        this.level = level;
        this.setChanged(true);
    }

    public void setExpirationTime(LocalDateTime expirationTime) {
        this.expirationTime = expirationTime;
        this.setChanged(true);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getEnhancementName() {
        return this.enhancementName;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public LocalDateTime getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public TeamEnhancement() {
    }
}

