/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.database;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamData;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseField;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.DatabaseTable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@DatabaseTable(tableName="team_mission")
public class TeamMission
extends TeamData {
    @DatabaseField(columnName="id", generatedId=true, canBeNull=false)
    private int id;
    @DatabaseField(columnName="mission_name", uniqueCombo=true)
    private String missionName;
    @DatabaseField(columnName="mission_level", uniqueCombo=true)
    private int missionLevel;
    @DatabaseField(columnName="expiration")
    private LocalDateTime expiration;

    public TeamMission(@NotNull Team team, String missionName, LocalDateTime expiration) {
        super(team);
        this.missionName = missionName;
        this.expiration = expiration;
        this.missionLevel = 1;
    }

    public long getRemainingTime() {
        if (this.expiration == null) {
            return 0L;
        }
        return LocalDateTime.now().until(this.expiration, ChronoUnit.SECONDS);
    }

    public boolean hasExpired() {
        if (this.expiration == null) {
            return false;
        }
        return this.expiration.isBefore(LocalDateTime.now());
    }

    public void setMissionLevel(int missionLevel) {
        this.missionLevel = missionLevel;
        this.setChanged(true);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getMissionName() {
        return this.missionName;
    }

    @Generated
    public int getMissionLevel() {
        return this.missionLevel;
    }

    @Generated
    public LocalDateTime getExpiration() {
        return this.expiration;
    }

    @Generated
    public TeamMission() {
    }
}

