/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Permission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class PermissionsGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final IridiumTeams<T, U> iridiumTeams;
    private final T team;
    private final int rank;
    private int page;

    public PermissionsGUI(T team, int rank, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().permissionsGUI.background, player, iridiumTeams.getInventories().backButton);
        this.iridiumTeams = iridiumTeams;
        this.team = team;
        this.rank = rank;
        this.page = 1;
    }

    public PermissionsGUI(T team, int rank, int page, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().permissionsGUI.background, player, iridiumTeams.getInventories().backButton);
        this.iridiumTeams = iridiumTeams;
        this.team = team;
        this.rank = rank;
        this.page = page;
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.iridiumTeams.getInventories().permissionsGUI.size, (String)StringUtils.color(this.iridiumTeams.getInventories().permissionsGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (Map.Entry<String, Permission> permission : this.iridiumTeams.getPermissionList().entrySet()) {
            if (permission.getValue().getPage() != this.page) continue;
            boolean allowed = this.iridiumTeams.getTeamManager().getTeamPermission(this.team, this.rank, permission.getKey());
            inventory.setItem(permission.getValue().getItem().slot.intValue(), ItemStackUtils.makeItem(permission.getValue().getItem(), Collections.singletonList(new Placeholder("permission", allowed ? this.iridiumTeams.getPermissions().allowed : this.iridiumTeams.getPermissions().denied))));
        }
        inventory.setItem(inventory.getSize() - 3, ItemStackUtils.makeItem(this.iridiumTeams.getInventories().nextPage));
        inventory.setItem(inventory.getSize() - 7, ItemStackUtils.makeItem(this.iridiumTeams.getInventories().previousPage));
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        if (event.getSlot() == this.iridiumTeams.getInventories().permissionsGUI.size - 7 && this.page > 1) {
            --this.page;
            event.getWhoClicked().openInventory(this.getInventory());
            return;
        }
        if (event.getSlot() == this.iridiumTeams.getInventories().permissionsGUI.size - 3 && this.iridiumTeams.getPermissionList().values().stream().anyMatch(permission -> permission.getPage() == this.page + 1)) {
            ++this.page;
            event.getWhoClicked().openInventory(this.getInventory());
        }
        for (Map.Entry<String, Permission> permission2 : this.iridiumTeams.getPermissionList().entrySet()) {
            if (permission2.getValue().getItem().slot.intValue() != event.getSlot() || permission2.getValue().getPage() != this.page) continue;
            this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().setPermissionCommand, new String[]{permission2.getKey(), this.iridiumTeams.getUserRanks().get((Object)Integer.valueOf((int)this.rank)).name});
            return;
        }
    }

    @Generated
    public int getRank() {
        return this.rank;
    }

    @Generated
    public int getPage() {
        return this.page;
    }
}

