/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Shop;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopCategoryGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final IridiumTeams<T, U> iridiumTeams;
    private final String categoryName;
    private final Shop.ShopCategory shopCategory;
    private int page;

    public ShopCategoryGUI(String categoryName, Player player, int page, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().shopCategoryGUI.background, player, iridiumTeams.getInventories().backButton);
        this.iridiumTeams = iridiumTeams;
        this.categoryName = categoryName;
        this.shopCategory = iridiumTeams.getShop().categories.get(categoryName);
        this.page = page;
    }

    @NotNull
    public Inventory getInventory() {
        NoItemGUI noItemGUI = this.iridiumTeams.getInventories().shopOverviewGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.shopCategory.inventorySize, (String)StringUtils.color(noItemGUI.title.replace("%category_name%", this.categoryName)));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        if (!this.iridiumTeams.getShop().items.containsKey(this.categoryName)) {
            this.iridiumTeams.getLogger().warning("Shop Category " + this.categoryName + " Is not configured with any items!");
            return;
        }
        for (Shop.ShopItem shopItem : this.iridiumTeams.getShop().items.get(this.categoryName)) {
            if (shopItem.page != this.page) continue;
            ItemStack itemStack = shopItem.type.parseItem();
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemStack.setAmount(shopItem.defaultAmount);
            itemMeta.setDisplayName(StringUtils.color(shopItem.name));
            itemMeta.setLore(this.getShopLore(shopItem));
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(shopItem.slot, itemStack);
        }
        inventory.setItem(inventory.getSize() - 3, ItemStackUtils.makeItem(this.iridiumTeams.getInventories().nextPage));
        inventory.setItem(inventory.getSize() - 7, ItemStackUtils.makeItem(this.iridiumTeams.getInventories().previousPage));
    }

    private List<Placeholder> getShopLorePlaceholders(Shop.ShopItem item) {
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>(Arrays.asList(new Placeholder("amount", this.iridiumTeams.getShopManager().formatPrice(item.defaultAmount)), new Placeholder("vault_cost", this.iridiumTeams.getShopManager().formatPrice(item.buyCost.money)), new Placeholder("vault_reward", this.iridiumTeams.getShopManager().formatPrice(item.sellCost.money)), new Placeholder("minLevel", String.valueOf(item.minLevel))));
        for (Map.Entry<String, Double> bankItem : item.buyCost.bankItems.entrySet()) {
            placeholders.add(new Placeholder(bankItem.getKey() + "_cost", this.iridiumTeams.getShopManager().formatPrice(bankItem.getValue())));
        }
        for (Map.Entry<String, Double> bankItem : item.sellCost.bankItems.entrySet()) {
            placeholders.add(new Placeholder(bankItem.getKey() + "_reward", this.iridiumTeams.getShopManager().formatPrice(bankItem.getValue())));
        }
        return placeholders;
    }

    private List<String> getShopLore(Shop.ShopItem item) {
        ArrayList<String> lore = item.lore == null ? new ArrayList<String>() : new ArrayList<String>(StringUtils.color(item.lore));
        List<Placeholder> placeholders = this.getShopLorePlaceholders(item);
        if (item.buyCost.canPurchase()) {
            lore.add(this.iridiumTeams.getShop().buyPriceLore);
        } else {
            lore.add(this.iridiumTeams.getShop().notPurchasableLore);
        }
        if (item.minLevel > 1) {
            lore.add(this.iridiumTeams.getShop().levelRequirementLore);
        }
        if (item.sellCost.canPurchase()) {
            lore.add(this.iridiumTeams.getShop().sellRewardLore);
        } else {
            lore.add(this.iridiumTeams.getShop().notSellableLore);
        }
        lore.addAll(this.iridiumTeams.getShop().shopItemLore);
        return StringUtils.color(StringUtils.processMultiplePlaceholders(lore, placeholders));
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        int amount;
        super.onInventoryClick(event);
        if (event.getSlot() == event.getInventory().getSize() - 3 && this.doesNextPageExist()) {
            ++this.page;
            this.addContent(event.getInventory());
            return;
        }
        if (event.getSlot() == event.getInventory().getSize() - 7 && this.doesPreviousPageExist()) {
            --this.page;
            this.addContent(event.getInventory());
            return;
        }
        Optional<Shop.ShopItem> shopItem = this.iridiumTeams.getShop().items.get(this.categoryName).stream().filter(item -> item.slot == event.getSlot()).filter(item -> item.page == this.page).findAny();
        if (!shopItem.isPresent()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int n = amount = event.isShiftClick() ? shopItem.get().type.parseItem().getMaxStackSize() : shopItem.get().defaultAmount;
        if (event.isLeftClick() && shopItem.get().buyCost.canPurchase()) {
            this.iridiumTeams.getShopManager().buy(player, shopItem.get(), amount);
        } else if (event.isRightClick() && shopItem.get().sellCost.canPurchase()) {
            this.iridiumTeams.getShopManager().sell(player, shopItem.get(), amount);
        } else {
            this.iridiumTeams.getShop().failSound.play((Entity)player);
        }
    }

    private boolean doesNextPageExist() {
        return this.iridiumTeams.getShop().items.get(this.categoryName).stream().anyMatch(item -> item.page == this.page + 1);
    }

    private boolean doesPreviousPageExist() {
        return this.iridiumTeams.getShop().items.get(this.categoryName).stream().anyMatch(item -> item.page == this.page - 1);
    }

    @Generated
    public String getCategoryName() {
        return this.categoryName;
    }

    @Generated
    public int getPage() {
        return this.page;
    }
}

