/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.Shop;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.ShopCategoryGUI;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ShopOverviewGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final IridiumTeams<T, U> iridiumTeams;

    public ShopOverviewGUI(Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().shopOverviewGUI.background, player, iridiumTeams.getInventories().backButton);
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        NoItemGUI noItemGUI = this.iridiumTeams.getInventories().shopOverviewGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)noItemGUI.size, (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (Shop.ShopCategory category : this.iridiumTeams.getShop().categories.values()) {
            inventory.setItem(category.item.slot.intValue(), ItemStackUtils.makeItem(category.item));
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        for (Map.Entry<String, Shop.ShopCategory> category : this.iridiumTeams.getShop().categories.entrySet()) {
            if (event.getSlot() != category.getValue().item.slot.intValue()) continue;
            event.getWhoClicked().openInventory(new ShopCategoryGUI<T, U>(category.getKey(), (Player)event.getWhoClicked(), 1, this.iridiumTeams).getInventory());
            return;
        }
        super.onInventoryClick(event);
    }
}

