/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.FarmingEnhancementData;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.Effect;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockSpreadEvent;

public class BlockGrowListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;
    private final List<XMaterial> ageIgnoreList = Arrays.asList(XMaterial.SUGAR_CANE, XMaterial.CACTUS, XMaterial.BAMBOO, XMaterial.CAVE_VINES);

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void monitorBlockGrow(BlockGrowEvent event) {
        XMaterial material = XMaterial.matchXMaterial(event.getNewState().getType());
        this.iridiumTeams.getTeamManager().getTeamViaLocation(event.getBlock().getLocation()).ifPresent(team -> {
            if (event.getNewState().getBlockData() instanceof Ageable) {
                Ageable ageable = (Ageable)event.getNewState().getBlockData();
                if (ageable.getAge() >= ageable.getMaximumAge() || this.ageIgnoreList.contains(material)) {
                    this.iridiumTeams.getMissionManager().handleMissionUpdate((Team)team, event.getBlock().getLocation().getWorld(), "GROW", material.name(), 1);
                }
                Enhancement<FarmingEnhancementData> farmingEnhancement = this.iridiumTeams.getEnhancements().farmingEnhancement;
                TeamEnhancement teamEnhancement = this.iridiumTeams.getTeamManager().getTeamEnhancement((Team)team, "farming");
                FarmingEnhancementData data = (FarmingEnhancementData)farmingEnhancement.levels.get(teamEnhancement.getLevel());
                if (teamEnhancement.isActive(farmingEnhancement.type) && data != null) {
                    ageable.setAge(Math.min(ageable.getAge() + data.farmingModifier, ageable.getMaximumAge()));
                    event.getNewState().setBlockData((BlockData)ageable);
                    try {
                        event.getBlock().getWorld().playEffect(event.getBlock().getLocation(), Effect.BONE_MEAL_USE, 0);
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                }
            } else {
                this.iridiumTeams.getMissionManager().handleMissionUpdate((Team)team, event.getBlock().getLocation().getWorld(), "GROW", material.name(), 1);
            }
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void monitorBlockSpread(BlockSpreadEvent event) {
        this.monitorBlockGrow((BlockGrowEvent)event);
    }

    @Generated
    public BlockGrowListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

