/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.SettingType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class EntitySpawnListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler(ignoreCancelled=true)
    public void onEntitySpawn(EntitySpawnEvent event) {
        Optional<Team> currentTeam = this.iridiumTeams.getTeamManager().getTeamViaLocation(event.getEntity().getLocation());
        if (currentTeam.isPresent()) {
            TeamSetting teamSetting = this.iridiumTeams.getTeamManager().getTeamSetting((Team)currentTeam.get(), SettingType.MOB_SPAWNING.getSettingKey());
            if (teamSetting == null) {
                return;
            }
            if (teamSetting.getValue().equalsIgnoreCase("Disabled") && event.getEntity() instanceof LivingEntity && event.getEntityType() != EntityType.ARMOR_STAND) {
                event.setCancelled(true);
            }
        }
        event.getEntity().setMetadata("team_spawned", (MetadataValue)new FixedMetadataValue(this.iridiumTeams, (Object)currentTeam.map(Team::getId).orElse(0)));
    }

    @Generated
    public EntitySpawnListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

