/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMoveListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        Location from = event.getFrom();
        if (from.getBlockX() == to.getBlockX() && from.getBlockZ() == to.getBlockZ() && from.getBlockY() == to.getBlockY()) {
            return;
        }
        Player player = event.getPlayer();
        Optional<Team> fromTeam = this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(event.getPlayer(), from);
        Optional<Team> toTeam = this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(event.getPlayer(), to);
        if (fromTeam.isPresent()) {
            this.iridiumTeams.getTeamManager().sendTeamTime(player);
            this.iridiumTeams.getTeamManager().sendTeamWeather(player);
        }
        if (toTeam.isPresent() && !this.iridiumTeams.getTeamManager().canVisit(player, (Team)toTeam.get())) {
            event.setCancelled(true);
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotVisit.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
            return;
        }
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        if (this.iridiumTeams.getEnhancements().flightEnhancement.enabled && ((IridiumUser)user).isFlying() && !((IridiumUser)user).canFly(this.iridiumTeams) && player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            ((IridiumUser)user).setFlying(false);
            player.setFlying(false);
            player.setAllowFlight(false);
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().flightDisabled.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
        }
        if (!toTeam.isPresent()) {
            return;
        }
        if (!toTeam.map(Team::getId).orElse(-99999).equals(fromTeam.map(Team::getId).orElse(-99999))) {
            this.iridiumTeams.getTeamManager().sendTeamTitle(player, (Team)toTeam.get());
        }
    }

    @Generated
    public PlayerMoveListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

