/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportCancelReason;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportManager;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportRequest;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getTo() == null) {
            return;
        }
        this.handleTeleportRequest(event.getPlayer(), (player, request) -> {
            if (this.hasPlayerMovedBlock(event) && request.hasPlayerMoved(this.iridiumTeams.getConfiguration().teleportMovementThreshold)) {
                this.iridiumTeams.getTeleportManager().cancelTeleport(player.getUniqueId(), TeleportCancelReason.PLAYER_MOVED);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        UUID playerId = player.getUniqueId();
        TeleportManager<T, U> teleportManager = this.iridiumTeams.getTeleportManager();
        if (teleportManager.hasActiveTeleport(playerId)) {
            teleportManager.cancelTeleport(playerId, TeleportCancelReason.PLAYER_DAMAGED);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        TeleportManager<T, U> teleportManager = this.iridiumTeams.getTeleportManager();
        if (teleportManager.hasActiveTeleport(playerId)) {
            teleportManager.cancelTeleport(playerId, TeleportCancelReason.PLAYER_OFFLINE);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getTo() == null) {
            return;
        }
        this.handleTeleportRequest(event.getPlayer(), (player, request) -> {
            if (this.locationsAreClose(event.getTo(), request.getDestination(), 0.5)) {
                this.iridiumTeams.getTeleportManager().cancelTeleport(player.getUniqueId(), TeleportCancelReason.OTHER_TELEPORT);
            }
        });
    }

    private void handleTeleportRequest(Player player, BiConsumer<Player, TeleportRequest<T, U>> consumer) {
        UUID playerId = player.getUniqueId();
        TeleportManager<T, U> teleportManager = this.iridiumTeams.getTeleportManager();
        Optional<TeleportRequest<TeleportRequest, U>> requestOpt = teleportManager.getTeleportRequest(playerId);
        requestOpt.ifPresent(request -> consumer.accept(player, (TeleportRequest)request));
    }

    private boolean hasPlayerMovedBlock(PlayerMoveEvent event) {
        if (event.getTo() == null) {
            return false;
        }
        return event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockY() != event.getTo().getBlockY() || event.getFrom().getBlockZ() != event.getTo().getBlockZ();
    }

    private boolean locationsAreClose(Location loc1, Location loc2, double threshold) {
        if (loc1 == null || loc2 == null) {
            return false;
        }
        if (loc1.getWorld() == null || loc2.getWorld() == null) {
            return false;
        }
        if (!loc1.getWorld().equals(loc2.getWorld())) {
            return false;
        }
        return loc1.distance(loc2) <= threshold;
    }

    @Generated
    public TeleportListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

