/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.managers;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.annotations.Nullable;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.TimeUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public abstract class CommandManager<T extends Team, U extends IridiumUser<T>>
implements CommandExecutor,
TabCompleter {
    private final List<com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command<T, U>> commands = new ArrayList<com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command<T, U>>();
    private final String command;
    private final String color;
    private final IridiumTeams<T, U> iridiumTeams;

    public CommandManager(IridiumTeams<T, U> iridiumTeams, String color, String command) {
        this.iridiumTeams = iridiumTeams;
        this.command = command;
        this.color = color;
        iridiumTeams.getCommand(command).setExecutor((CommandExecutor)this);
        iridiumTeams.getCommand(command).setTabCompleter((TabCompleter)this);
        this.registerCommands();
    }

    public void registerCommands() {
        this.registerCommand(this.iridiumTeams.getCommands().aboutCommand);
        this.registerCommand(this.iridiumTeams.getCommands().createCommand);
        this.registerCommand(this.iridiumTeams.getCommands().membersCommand);
        this.registerCommand(this.iridiumTeams.getCommands().permissionsCommand);
        this.registerCommand(this.iridiumTeams.getCommands().setPermissionCommand);
        this.registerCommand(this.iridiumTeams.getCommands().promoteCommand);
        this.registerCommand(this.iridiumTeams.getCommands().demoteCommand);
        this.registerCommand(this.iridiumTeams.getCommands().helpCommand);
        this.registerCommand(this.iridiumTeams.getCommands().reloadCommand);
        this.registerCommand(this.iridiumTeams.getCommands().inviteCommand);
        this.registerCommand(this.iridiumTeams.getCommands().unInviteCommand);
        this.registerCommand(this.iridiumTeams.getCommands().invitesCommand);
        this.registerCommand(this.iridiumTeams.getCommands().trustCommand);
        this.registerCommand(this.iridiumTeams.getCommands().unTrustCommand);
        this.registerCommand(this.iridiumTeams.getCommands().trustsCommand);
        this.registerCommand(this.iridiumTeams.getCommands().kickCommand);
        this.registerCommand(this.iridiumTeams.getCommands().leaveCommand);
        this.registerCommand(this.iridiumTeams.getCommands().deleteCommand);
        this.registerCommand(this.iridiumTeams.getCommands().infoCommand);
        this.registerCommand(this.iridiumTeams.getCommands().descriptionCommand);
        this.registerCommand(this.iridiumTeams.getCommands().renameCommand);
        this.registerCommand(this.iridiumTeams.getCommands().setHomeCommand);
        this.registerCommand(this.iridiumTeams.getCommands().homeCommand);
        this.registerCommand(this.iridiumTeams.getCommands().bypassCommand);
        this.registerCommand(this.iridiumTeams.getCommands().transferCommand);
        this.registerCommand(this.iridiumTeams.getCommands().joinCommand);
        this.registerCommand(this.iridiumTeams.getCommands().bankCommand);
        this.registerCommand(this.iridiumTeams.getCommands().depositCommand);
        this.registerCommand(this.iridiumTeams.getCommands().withdrawCommand);
        this.registerCommand(this.iridiumTeams.getCommands().chatCommand);
        this.registerCommand(this.iridiumTeams.getCommands().boostersCommand);
        this.registerCommand(this.iridiumTeams.getCommands().upgradesCommand);
        this.registerCommand(this.iridiumTeams.getCommands().flyCommand);
        this.registerCommand(this.iridiumTeams.getCommands().topCommand);
        this.registerCommand(this.iridiumTeams.getCommands().recalculateCommand);
        this.registerCommand(this.iridiumTeams.getCommands().warpsCommand);
        this.registerCommand(this.iridiumTeams.getCommands().warpCommand);
        this.registerCommand(this.iridiumTeams.getCommands().setWarpCommand);
        this.registerCommand(this.iridiumTeams.getCommands().deleteWarpCommand);
        this.registerCommand(this.iridiumTeams.getCommands().editWarpCommand);
        this.registerCommand(this.iridiumTeams.getCommands().missionsCommand);
        this.registerCommand(this.iridiumTeams.getCommands().rewardsCommand);
        this.registerCommand(this.iridiumTeams.getCommands().experienceCommand);
        this.registerCommand(this.iridiumTeams.getCommands().shopCommand);
        this.registerCommand(this.iridiumTeams.getCommands().settingsCommand);
        this.registerCommand(this.iridiumTeams.getCommands().blockValueCommand);
        this.registerCommand(this.iridiumTeams.getCommands().levelCommand);
    }

    public void registerCommand(com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command<T, U> command) {
        if (!command.enabled) {
            return;
        }
        int index = Collections.binarySearch(this.commands, command, Comparator.comparing(cmd -> cmd.aliases.get(0)));
        this.commands.add(index < 0 ? -(index + 1) : index, command);
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.noArgsDefault(commandSender);
            return true;
        }
        for (com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command<T, U> command : this.commands) {
            if (!command.aliases.contains(args[0])) continue;
            return this.executeCommand(commandSender, command, Arrays.copyOfRange(args, 1, args.length));
        }
        commandSender.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().unknownCommand.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
        return false;
    }

    public boolean executeCommand(CommandSender commandSender, com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command<T, U> command, String[] args) {
        if (!command.hasPermission(commandSender, this.iridiumTeams)) {
            commandSender.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().noPermission.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (command.isOnCooldown(commandSender, this.iridiumTeams)) {
            Duration remainingTime = command.getCooldownProvider().getRemainingTime(commandSender);
            String formattedTime = TimeUtils.formatDuration(this.iridiumTeams.getMessages().activeCooldown, remainingTime);
            commandSender.sendMessage(StringUtils.color(formattedTime.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (command.execute(commandSender, args, (IridiumTeams<T, CommandSender>)this.iridiumTeams)) {
            command.getCooldownProvider().applyCooldown(commandSender);
        }
        return true;
    }

    public abstract void noArgsDefault(@NotNull CommandSender var1);

    private List<String> getTabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> result = new ArrayList<String>();
            for (com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command<T, U> command : this.commands) {
                if (command.isSuperSecretCommand()) continue;
                for (String alias : command.aliases) {
                    if (!alias.toLowerCase().startsWith(args[0].toLowerCase()) || !command.hasPermission(commandSender, this.iridiumTeams)) continue;
                    result.add(alias);
                }
            }
            return result.stream().sorted().collect(Collectors.toList());
        }
        for (com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command<T, U> command : this.commands) {
            if (command.isSuperSecretCommand() || !command.aliases.contains(args[0].toLowerCase()) || !command.hasPermission(commandSender, this.iridiumTeams)) continue;
            return command.onTabComplete(commandSender, Arrays.copyOfRange(args, 1, args.length), this.iridiumTeams);
        }
        return Collections.emptyList();
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command cmd, @NotNull String label, String[] args) {
        List<String> tabComplete = this.getTabComplete(commandSender, args);
        if (tabComplete == null) {
            return null;
        }
        return tabComplete.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).sorted().collect(Collectors.toList());
    }

    @Generated
    public List<com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command<T, U>> getCommands() {
        return this.commands;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public String getColor() {
        return this.color;
    }
}

