/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.managers;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamMission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamMissionData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamReward;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.MissionGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.Mission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.MissionData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.MissionType;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class MissionManager<T extends Team, U extends IridiumUser<T>> {
    private final IridiumTeams<T, U> iridiumTeams;

    public MissionManager(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    public LocalDateTime getExpirationTime(MissionType missionType, LocalDateTime startTime) {
        LocalDateTime baseTime = startTime.withSecond(0).withMinute(0).withHour(0);
        switch (missionType) {
            case ONCE: {
                return null;
            }
            case DAILY: {
                return baseTime.plusDays(1L);
            }
            case WEEKLY: {
                return baseTime.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
            }
            case INFINITE: {
                return null;
            }
        }
        return null;
    }

    public void handleMissionUpdate(T team, World missionWorld, String missionType, String identifier, int amount) {
        if (this.iridiumTeams.getConfiguration().whitelistedWorlds.stream().noneMatch(world -> missionWorld.getName().equalsIgnoreCase((String)world)) && !this.iridiumTeams.getConfiguration().whitelistedWorlds.isEmpty()) {
            return;
        }
        this.generateMissionData(team);
        this.incrementMission(team, missionType + ":" + identifier, amount);
        this.incrementMission(team, missionType + ":ANY", amount);
        this.incrementMission(team, missionWorld.getEnvironment().name() + ":" + missionType + ":" + identifier, amount);
        this.incrementMission(team, missionWorld.getEnvironment().name() + ":" + missionType + ":ANY", amount);
        for (Map.Entry<String, List<String>> itemList : this.iridiumTeams.getMissions().customMaterialLists.entrySet()) {
            if (!itemList.getValue().contains(identifier)) continue;
            this.incrementMission(team, missionType + ":" + itemList.getKey(), amount);
            this.incrementMission(team, missionWorld.getEnvironment().name() + ":" + missionType + ":" + itemList.getKey(), amount);
        }
    }

    private synchronized void incrementMission(T team, String condition, int amount) {
        List<TeamMission> teamMissions = this.iridiumTeams.getTeamManager().getTeamMissions(team);
        String[] missionConditions = condition.toUpperCase().split(":");
        for (Map.Entry<String, Mission> entry : this.iridiumTeams.getMissions().missions.entrySet()) {
            Optional<TeamMission> teamMission = teamMissions.stream().filter(mission -> mission.getMissionName().equals(entry.getKey())).findFirst();
            if (!teamMission.isPresent()) continue;
            boolean completedBefore = true;
            int level = teamMissions.stream().filter(m -> m.getMissionName().equals(entry.getKey())).map(TeamMission::getMissionLevel).findFirst().orElse(1);
            MissionData missionData = entry.getValue().getMissionData().get(level);
            if (((Team)team).getLevel() < missionData.getMinLevel() || !this.dependenciesComplete(team, missionData.getMissionDependencies(), teamMissions)) continue;
            List<String> missions = missionData.getMissions();
            for (int missionIndex = 0; missionIndex < missions.size(); ++missionIndex) {
                boolean matches;
                TeamMissionData teamMissionData = this.iridiumTeams.getTeamManager().getTeamMissionData(teamMission.get(), missionIndex);
                String missionRequirement = missions.get(missionIndex).toUpperCase();
                String[] conditions = missionRequirement.split(":");
                if (missionConditions.length + 1 != conditions.length || !(matches = this.matchesMission(missionConditions, conditions))) continue;
                String number = conditions[condition.split(":").length];
                try {
                    int totalAmount = Integer.parseInt(number);
                    if (teamMissionData.getProgress() >= totalAmount) break;
                    completedBefore = false;
                    teamMissionData.setProgress(Math.min(teamMissionData.getProgress() + amount, totalAmount));
                    continue;
                }
                catch (NumberFormatException exception) {
                    this.iridiumTeams.getLogger().warning("Unknown format " + missionRequirement);
                    this.iridiumTeams.getLogger().warning(number + " Is not a number");
                }
            }
            if (completedBefore || !this.hasCompletedMission(team, entry.getKey(), missionData)) continue;
            this.iridiumTeams.getTeamManager().addTeamReward(new TeamReward((Team)team, missionData.getReward()));
            this.iridiumTeams.getTeamManager().getTeamMembers(team).stream().map(IridiumUser::getPlayer).filter(Objects::nonNull).forEach(member -> {
                member.sendMessage(StringUtils.color(missionData.getMessage().replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                missionData.getCompleteSound().play((Entity)member);
            });
            if (!entry.getValue().getMissionData().containsKey(level + 1)) continue;
            teamMission.get().setMissionLevel(level + 1);
            this.iridiumTeams.getTeamManager().resetTeamMissionData(teamMission.get());
        }
    }

    private boolean dependenciesComplete(T team, List<MissionData.MissionDependency> missionDependencies, List<TeamMission> teamMissions) {
        for (MissionData.MissionDependency missionDependency : missionDependencies) {
            Optional<TeamMission> teamMission = teamMissions.stream().filter(mission -> mission.getMissionName().equals(missionDependency.getMission())).filter(mission -> mission.getMissionLevel() == missionDependency.getLevel()).findFirst();
            if (!teamMission.isPresent()) {
                return false;
            }
            MissionData missionData = this.iridiumTeams.getMissions().missions.get(missionDependency.getMission()).getMissionData().get(missionDependency.getLevel());
            if (this.hasCompletedMission(team, missionDependency.getMission(), missionData)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesMission(String[] missionConditions, String[] conditions) {
        for (int i = 0; i < missionConditions.length; ++i) {
            if (conditions[i].equals(missionConditions[i])) continue;
            return false;
        }
        return true;
    }

    private boolean hasCompletedMission(T team, String missionName, MissionData missionData) {
        List<String> missions = missionData.getMissions();
        TeamMission teamMission = this.iridiumTeams.getTeamManager().getTeamMission(team, missionName);
        for (int missionIndex = 0; missionIndex < missions.size(); ++missionIndex) {
            TeamMissionData teamMissionData = this.iridiumTeams.getTeamManager().getTeamMissionData(teamMission, missionIndex);
            String missionRequirement = missions.get(missionIndex).toUpperCase();
            String[] conditions = missionRequirement.split(":");
            String number = conditions[conditions.length - 1];
            try {
                if (teamMissionData.getProgress() >= Integer.parseInt(number)) continue;
                return false;
            }
            catch (NumberFormatException exception) {
                this.iridiumTeams.getLogger().warning("Unknown format " + missionRequirement);
                this.iridiumTeams.getLogger().warning(number + " Is not a number");
            }
        }
        return true;
    }

    public void generateMissionData(T team) {
        new MissionGUI<T, U>(team, MissionType.ONCE, null, this.iridiumTeams).getInventory();
        new MissionGUI<T, U>(team, MissionType.DAILY, null, this.iridiumTeams).getInventory();
        new MissionGUI<T, U>(team, MissionType.WEEKLY, null, this.iridiumTeams).getInventory();
    }
}

