/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.managers;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.EssentialsSpawnSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.ObsidianStackerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.RoseStackerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.SpawnSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.SpawnerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.StackerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.WildStackerSupport;
import java.util.HashSet;
import lombok.Generated;
import org.bukkit.Bukkit;

public class SupportManager<T extends Team, U extends IridiumUser<T>> {
    private final IridiumTeams<T, U> iridiumTeams;
    private HashSet<StackerSupport<T>> stackerSupport = new HashSet();
    private HashSet<SpawnerSupport<T>> spawnerSupport = new HashSet();
    private HashSet<SpawnSupport<T>> spawnSupport = new HashSet();
    private HashSet<String> providerList = new HashSet();

    public SupportManager(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    public boolean supportedPluginEnabled(String pluginName) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginName);
    }

    private void registerBlockStackerSupport() {
        if (this.supportedPluginEnabled("RoseStacker")) {
            this.stackerSupport.add(new RoseStackerSupport<T, U>(this.iridiumTeams));
        }
        if (this.supportedPluginEnabled("WildStacker")) {
            this.stackerSupport.add(new WildStackerSupport<T, U>(this.iridiumTeams));
        }
        if (this.supportedPluginEnabled("ObsidianStacker")) {
            this.stackerSupport.add(new ObsidianStackerSupport<T, U>(this.iridiumTeams));
        }
    }

    private void registerSpawnerSupport() {
        if (this.supportedPluginEnabled("RoseStacker")) {
            this.spawnerSupport.add(new RoseStackerSupport<T, U>(this.iridiumTeams));
        }
        if (this.supportedPluginEnabled("WildStacker")) {
            this.spawnerSupport.add(new WildStackerSupport<T, U>(this.iridiumTeams));
        }
    }

    private void registerSpawnSupport() {
        if (this.supportedPluginEnabled("EssentialsSpawn")) {
            this.spawnSupport.add(new EssentialsSpawnSupport<T, U>(this.iridiumTeams));
        }
    }

    public void registerSupport() {
        this.registerBlockStackerSupport();
        this.registerSpawnerSupport();
        this.registerSpawnSupport();
        this.stackerSupport.forEach(provider -> this.providerList.add(provider.supportProvider()));
        this.spawnerSupport.forEach(provider -> this.providerList.add(provider.supportProvider()));
        this.spawnSupport.forEach(provider -> this.providerList.add(provider.supportProvider()));
    }

    @Generated
    public HashSet<StackerSupport<T>> getStackerSupport() {
        return this.stackerSupport;
    }

    @Generated
    public HashSet<SpawnerSupport<T>> getSpawnerSupport() {
        return this.spawnerSupport;
    }

    @Generated
    public HashSet<SpawnSupport<T>> getSpawnSupport() {
        return this.spawnSupport;
    }

    @Generated
    public HashSet<String> getProviderList() {
        return this.providerList;
    }
}

