/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.support;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.StackerSupport;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import com.moyskleytech.obsidianstacker.api.Stack;
import com.moyskleytech.obsidianstacker.api.StackerAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Chunk;
import org.bukkit.block.Block;

public class ObsidianStackerSupport<T extends Team, U extends IridiumUser<T>>
implements StackerSupport<T> {
    private final IridiumTeams<T, U> iridiumTeams;

    public ObsidianStackerSupport(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    @Override
    public String supportProvider() {
        return "ObsidianStacker";
    }

    @Override
    public boolean isStackedBlock(Block block) {
        Optional stackedBlock = StackerAPI.getInstance().getStack(block);
        return stackedBlock.isPresent();
    }

    private Stack getStackedBlock(Block block) {
        return (Stack)StackerAPI.getInstance().getStack(block).get();
    }

    private List<Stack> getStackedBlocks(List<Block> blocks) {
        ArrayList<Stack> stackedBlocks = new ArrayList<Stack>(Collections.emptyList());
        for (Block block : blocks) {
            stackedBlocks.add(this.getStackedBlock(block));
        }
        return stackedBlocks;
    }

    @Override
    public int getStackAmount(Block block) {
        return this.getStackedBlock(block).getCount();
    }

    @Override
    public Map<XMaterial, Integer> getBlocksStacked(Chunk chunk, T team) {
        HashMap<XMaterial, Integer> hashMap = new HashMap<XMaterial, Integer>();
        return hashMap;
    }

    @Override
    public int getExtraBlocks(T team, XMaterial material, List<Block> blocks) {
        int stackedBlocks = 0;
        for (Stack stack : this.getStackedBlocks(blocks)) {
            if (!this.iridiumTeams.getTeamManager().isInTeam(team, stack.getEntity().getLocation()) || material != XMaterial.matchXMaterial(stack.getEntity().getLocation().getBlock().getType())) continue;
            stackedBlocks += stack.getCount() - 1;
        }
        return stackedBlocks;
    }
}

