/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.support;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.SpawnerSupport;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.support.StackerSupport;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import dev.rosewood.rosestacker.api.RoseStackerAPI;
import dev.rosewood.rosestacker.stack.StackedBlock;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;

public class RoseStackerSupport<T extends Team, U extends IridiumUser<T>>
implements StackerSupport<T>,
SpawnerSupport<T> {
    private final IridiumTeams<T, U> iridiumTeams;

    public RoseStackerSupport(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    @Override
    public String supportProvider() {
        return "RoseStacker";
    }

    @Override
    public boolean isStackedBlock(Block block) {
        return RoseStackerAPI.getInstance().isBlockStacked(block);
    }

    @Override
    public boolean isStackedSpawner(Block block) {
        return RoseStackerAPI.getInstance().isSpawnerStacked(block);
    }

    private StackedBlock getStackedBlock(Block block) {
        return RoseStackerAPI.getInstance().getStackedBlock(block);
    }

    private StackedSpawner getStackedSpawner(Block block) {
        return RoseStackerAPI.getInstance().getStackedSpawner(block);
    }

    private List<StackedBlock> getStackedBlocks(List<Block> blocks) {
        ArrayList<StackedBlock> stackedBlocks = new ArrayList<StackedBlock>(Collections.emptyList());
        for (Block block : blocks) {
            stackedBlocks.add(this.getStackedBlock(block));
        }
        return stackedBlocks;
    }

    private List<StackedSpawner> getStackedSpawners(List<CreatureSpawner> spawners) {
        ArrayList<StackedSpawner> stackedSpawners = new ArrayList<StackedSpawner>(Collections.emptyList());
        for (CreatureSpawner spawner : spawners) {
            stackedSpawners.add(this.getStackedSpawner(spawner.getBlock()));
        }
        return stackedSpawners;
    }

    @Override
    public int getStackAmount(Block block) {
        return this.getStackedBlock(block).getStackSize();
    }

    @Override
    public int getStackAmount(CreatureSpawner spawner) {
        return this.getStackedSpawner(spawner.getBlock()).getStackSize();
    }

    @Override
    public int getSpawnAmount(CreatureSpawner spawner) {
        return this.getStackAmount(spawner) * RoseStackerAPI.getInstance().getStackedSpawner(spawner.getBlock()).getSpawner().getSpawnCount();
    }

    @Override
    public Map<XMaterial, Integer> getBlocksStacked(Chunk chunk, T team) {
        HashMap<XMaterial, Integer> hashMap = new HashMap<XMaterial, Integer>();
        RoseStackerAPI.getInstance().getStackedBlocks(Collections.singletonList(chunk)).forEach(stackedBlock -> {
            if (!this.iridiumTeams.getTeamManager().isInTeam((Team)team, stackedBlock.getLocation())) {
                return;
            }
            XMaterial xMaterial = XMaterial.matchXMaterial(stackedBlock.getStackSettings().getType());
            hashMap.put(xMaterial, hashMap.getOrDefault(xMaterial, 0) + stackedBlock.getStackSize());
        });
        return hashMap;
    }

    @Override
    public List<CreatureSpawner> getSpawnersStacked(Chunk chunk) {
        return RoseStackerAPI.getInstance().getStackedSpawners(Collections.singletonList(chunk)).stream().map(StackedSpawner::getSpawner).collect(Collectors.toList());
    }

    @Override
    public int getExtraBlocks(T team, XMaterial material, List<Block> blocks) {
        int stackedBlocks = 0;
        for (StackedBlock stackedBlock : this.getStackedBlocks(blocks)) {
            if (!this.iridiumTeams.getTeamManager().isInTeam(team, stackedBlock.getLocation()) || material != XMaterial.matchXMaterial(stackedBlock.getBlock().getType())) continue;
            stackedBlocks += stackedBlock.getStackSize() - 1;
        }
        return stackedBlocks;
    }

    @Override
    public int getExtraSpawners(T team, EntityType entityType, List<CreatureSpawner> spawners) {
        int stackedSpawners = 0;
        for (StackedSpawner stackedSpawner : this.getStackedSpawners(spawners)) {
            if (!this.iridiumTeams.getTeamManager().isInTeam(team, stackedSpawner.getLocation()) || stackedSpawner.getSpawner().getSpawnedType() != entityType) continue;
            stackedSpawners += stackedSpawner.getStackSize() - 1;
        }
        return stackedSpawners;
    }
}

