/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportCancelReason;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportRequest;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportType;
import com.iridium.iridiumskyblock.dependencies.lib.PaperLib;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportManager<T extends Team, U extends IridiumUser<T>> {
    private final IridiumTeams<T, U> iridiumTeams;
    private final Map<UUID, TeleportRequest<T, U>> activeRequests = new ConcurrentHashMap<UUID, TeleportRequest<T, U>>();

    public TeleportManager(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    public boolean startTeleport(Player player, Location destination, T team, TeleportType teleportType, String teleportName) {
        UUID playerId = player.getUniqueId();
        if (this.activeRequests.containsKey(playerId)) {
            this.cancelTeleport(playerId, TeleportCancelReason.NEW_REQUEST);
        }
        if (player.hasPermission(this.iridiumTeams.getConfiguration().teleportBypassPermission)) {
            return this.instantTeleport(player, destination);
        }
        int delay = this.iridiumTeams.getConfiguration().teleportDelay;
        if (delay <= 0) {
            return this.instantTeleport(player, destination);
        }
        TeleportRequest request = new TeleportRequest(playerId, destination, player.getLocation(), teleportType, team, teleportName, delay);
        this.activeRequests.put(playerId, request);
        player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().teleportStarted.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
        this.startCountdownTask(request);
        this.startDelayTask(request);
        return true;
    }

    public void cancelTeleport(UUID playerId, TeleportCancelReason reason) {
        String message;
        TeleportRequest<T, U> request = this.activeRequests.remove(playerId);
        if (request == null) {
            return;
        }
        request.cancelTasks();
        Optional<Player> player = request.getPlayer();
        if (player.isPresent() && player.get().isOnline() && (message = this.getTeleportCancelMessage(reason)) != null) {
            player.get().sendMessage(StringUtils.color(message.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
        }
    }

    public Optional<TeleportRequest<T, U>> getTeleportRequest(UUID playerId) {
        return Optional.ofNullable(this.activeRequests.get(playerId));
    }

    public boolean hasActiveTeleport(UUID playerId) {
        return this.activeRequests.containsKey(playerId);
    }

    private boolean instantTeleport(Player player, Location destination) {
        player.setFallDistance(0.0f);
        PaperLib.teleportAsync((Entity)player, destination);
        player.teleport(destination);
        return true;
    }

    private void startCountdownTask(final TeleportRequest<T, U> request) {
        BukkitRunnable countdownTask = new BukkitRunnable(){

            public void run() {
                Optional<Player> player = request.getPlayer();
                if (!player.isPresent() || !player.get().isOnline()) {
                    TeleportManager.this.cancelTeleport(request.getPlayerId(), TeleportCancelReason.PLAYER_OFFLINE);
                    return;
                }
                if (request.hasPlayerMoved(((TeleportManager)TeleportManager.this).iridiumTeams.getConfiguration().teleportMovementThreshold)) {
                    TeleportManager.this.cancelTeleport(request.getPlayerId(), TeleportCancelReason.PLAYER_MOVED);
                    return;
                }
                if (request.getRemainingSeconds() > 0) {
                    player.get().sendMessage(StringUtils.color(((TeleportManager)TeleportManager.this).iridiumTeams.getMessages().teleportDelay.replace("%prefix%", ((TeleportManager)TeleportManager.this).iridiumTeams.getConfiguration().prefix).replace("%delay%", String.valueOf(request.getRemainingSeconds()))));
                    request.setRemainingSeconds(request.getRemainingSeconds() - 1);
                }
            }
        };
        request.setCountdownTask(countdownTask);
        countdownTask.runTaskTimer(this.iridiumTeams, 0L, 20L);
    }

    private void startDelayTask(final TeleportRequest<T, U> request) {
        BukkitRunnable delayTask = new BukkitRunnable(){

            public void run() {
                UUID playerId = request.getPlayerId();
                Optional<Player> optionalPlayer = request.getPlayer();
                if (!optionalPlayer.isPresent() || !optionalPlayer.get().isOnline()) {
                    TeleportManager.this.activeRequests.remove(playerId);
                    return;
                }
                Player player = optionalPlayer.get();
                if (request.hasPlayerMoved(((TeleportManager)TeleportManager.this).iridiumTeams.getConfiguration().teleportMovementThreshold)) {
                    TeleportManager.this.cancelTeleport(playerId, TeleportCancelReason.PLAYER_MOVED);
                    return;
                }
                if (request.getCountdownTask() != null) {
                    request.getCountdownTask().cancel();
                }
                TeleportManager.this.activeRequests.remove(playerId);
                TeleportManager.this.instantTeleport(player, request.getDestination());
                TeleportManager.this.sendSuccessMessage(player, request);
            }
        };
        request.setDelayTask(delayTask);
        long delayTicks = (long)request.getRemainingSeconds() * 20L;
        delayTask.runTaskLater(this.iridiumTeams, delayTicks);
    }

    private void sendSuccessMessage(Player player, TeleportRequest<T, U> request) {
        String message;
        switch (request.getTeleportType()) {
            case HOME: {
                message = this.iridiumTeams.getMessages().teleportingHome;
                break;
            }
            case WARP: {
                message = this.iridiumTeams.getMessages().teleportingWarp.replace("%name%", request.getTeleportName() != null ? request.getTeleportName() : "unknown");
                break;
            }
            default: {
                message = this.iridiumTeams.getMessages().teleportStarted;
            }
        }
        player.sendMessage(StringUtils.color(message.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
    }

    private String getTeleportCancelMessage(TeleportCancelReason reason) {
        switch (reason) {
            case PLAYER_MOVED: {
                return this.iridiumTeams.getMessages().teleportCancelledMovement;
            }
            case PLAYER_DAMAGED: {
                return this.iridiumTeams.getMessages().teleportCancelledDamage;
            }
            case PLAYER_OFFLINE: 
            case NEW_REQUEST: {
                return null;
            }
        }
        return this.iridiumTeams.getMessages().teleportCancelled;
    }

    public void shutdown() {
        for (TeleportRequest<T, U> request : this.activeRequests.values()) {
            request.cancelTasks();
        }
        this.activeRequests.clear();
    }
}

