/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.dao;

import com.iridium.iridiumskyblock.dependencies.ormlite.dao.CloseableIterator;
import com.iridium.iridiumskyblock.dependencies.ormlite.dao.Dao;
import com.iridium.iridiumskyblock.dependencies.ormlite.dao.ForeignCollection;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.FieldType;
import com.iridium.iridiumskyblock.dependencies.ormlite.misc.IOUtils;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.PreparedQuery;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.QueryBuilder;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.SelectArg;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.mapped.MappedPreparedStmt;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;

public abstract class BaseForeignCollection<T, ID>
implements ForeignCollection<T>,
Serializable {
    private static final long serialVersionUID = -5158840898186237589L;
    protected final transient Dao<T, ID> dao;
    private final transient FieldType foreignFieldType;
    private final transient Object parentId;
    private transient PreparedQuery<T> preparedQuery;
    private final transient String orderColumn;
    private final transient boolean orderAscending;
    private final transient Object parent;

    protected BaseForeignCollection(Dao<T, ID> dao, Object parent, Object parentId, FieldType foreignFieldType, String orderColumn, boolean orderAscending) {
        this.dao = dao;
        this.foreignFieldType = foreignFieldType;
        this.parentId = parentId;
        this.orderColumn = orderColumn;
        this.orderAscending = orderAscending;
        this.parent = parent;
    }

    @Override
    public boolean add(T data) {
        try {
            return this.addElement(data);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not create data element in dao", e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean changed = false;
        for (T data : collection) {
            try {
                if (!this.addElement(data)) continue;
                changed = true;
            }
            catch (SQLException e) {
                throw new IllegalStateException("Could not create data elements in dao", e);
            }
        }
        return changed;
    }

    @Override
    public abstract boolean remove(Object var1);

    @Override
    public abstract boolean removeAll(Collection<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        if (this.dao == null) {
            return false;
        }
        boolean changed = false;
        CloseableIterator iterator = this.closeableIterator();
        try {
            while (iterator.hasNext()) {
                Object data = iterator.next();
                if (collection.contains(data)) continue;
                iterator.remove();
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(iterator);
        }
    }

    @Override
    public void clear() {
        if (this.dao == null) {
            return;
        }
        CloseableIterator iterator = this.closeableIterator();
        try {
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        finally {
            IOUtils.closeQuietly(iterator);
        }
    }

    @Override
    public int update(T data) throws SQLException {
        if (this.dao == null) {
            return 0;
        }
        return this.dao.update(data);
    }

    @Override
    public int refresh(T data) throws SQLException {
        if (this.dao == null) {
            return 0;
        }
        return this.dao.refresh(data);
    }

    @Override
    public Dao<T, ?> getDao() {
        return this.dao;
    }

    protected PreparedQuery<T> getPreparedQuery() throws SQLException {
        if (this.dao == null) {
            return null;
        }
        if (this.preparedQuery == null) {
            SelectArg fieldArg = new SelectArg();
            fieldArg.setValue(this.parentId);
            QueryBuilder<T, ID> qb = this.dao.queryBuilder();
            if (this.orderColumn != null) {
                qb.orderBy(this.orderColumn, this.orderAscending);
            }
            this.preparedQuery = qb.where().eq(this.foreignFieldType.getColumnName(), fieldArg).prepare();
            if (this.preparedQuery instanceof MappedPreparedStmt) {
                MappedPreparedStmt mappedStmt = (MappedPreparedStmt)this.preparedQuery;
                mappedStmt.setParentInformation(this.parent, this.parentId);
            }
        }
        return this.preparedQuery;
    }

    private boolean addElement(T data) throws SQLException {
        if (this.dao == null) {
            return false;
        }
        if (this.parent != null && this.foreignFieldType.getFieldValueIfNotDefault(data) == null) {
            this.foreignFieldType.assignField(this.dao.getConnectionSource(), data, this.parent, true, null);
        }
        this.dao.create(data);
        return true;
    }
}

