/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.stmt;

import com.iridium.iridiumskyblock.dependencies.ormlite.dao.Dao;
import com.iridium.iridiumskyblock.dependencies.ormlite.db.DatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.ArgumentHolder;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.PreparedDelete;
import com.iridium.iridiumskyblock.dependencies.ormlite.stmt.StatementBuilder;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.List;

public class DeleteBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private Long limit;

    public DeleteBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        super(databaseType, tableInfo, dao, StatementBuilder.StatementType.DELETE);
    }

    public PreparedDelete<T> prepare() throws SQLException {
        return super.prepareStatement(this.limit, false);
    }

    public int delete() throws SQLException {
        return this.dao.delete(this.prepare());
    }

    public DeleteBuilder<T, ID> limit(Long maxRows) {
        this.limit = maxRows;
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.limit = null;
    }

    @Override
    protected void appendStatementStart(StringBuilder sb, List<ArgumentHolder> argList) {
        sb.append("DELETE FROM ");
        if (this.tableInfo.getSchemaName() != null && this.tableInfo.getSchemaName().length() > 0) {
            this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getSchemaName());
            sb.append('.');
        }
        if (this.databaseType.isLimitAfterDeleteSupported()) {
            this.appendLimit(sb);
        }
        this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getTableName());
        sb.append(' ');
    }

    @Override
    protected void appendStatementEnd(StringBuilder sb, List<ArgumentHolder> argList) {
        if (this.databaseType.isLimitDeleteAtEndSupported()) {
            this.appendLimit(sb);
        }
    }

    private void appendLimit(StringBuilder sb) {
        if (this.limit != null) {
            this.databaseType.appendUpdateLimitValue(sb, this.limit);
        }
    }
}

