/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.managers;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Schematics;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import com.iridium.iridiumskyblock.schematics.FastAsyncWorldEdit;
import com.iridium.iridiumskyblock.schematics.SchematicAsync;
import com.iridium.iridiumskyblock.schematics.SchematicPaster;
import com.iridium.iridiumskyblock.schematics.WorldEdit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SchematicManager {
    public SchematicPaster schematicPaster;
    public final Map<String, File> schematicFiles;
    public final TreeMap<String, SchematicPaster> availablePasters;
    private final boolean worldEdit = Bukkit.getPluginManager().isPluginEnabled("WorldEdit");
    private final boolean fawe = Bukkit.getPluginManager().isPluginEnabled("FastAsyncWorldEdit") || Bukkit.getPluginManager().isPluginEnabled("AsyncWorldEdit");

    public SchematicManager() {
        this.availablePasters = new TreeMap();
        this.availablePasters.put("internalAsync", new SchematicAsync());
        if (this.worldEdit && WorldEdit.isWorking()) {
            this.availablePasters.put("worldedit", new WorldEdit());
        }
        if (this.fawe && FastAsyncWorldEdit.isWorking()) {
            this.availablePasters.put("fawe", new FastAsyncWorldEdit());
        }
        if (this.worldEdit && !WorldEdit.isWorking()) {
            IridiumSkyblock.getInstance().getLogger().warning("WorldEdit version doesn't support minecraft version, disabling WorldEdit integration");
        }
        if (this.fawe && !FastAsyncWorldEdit.isWorking()) {
            IridiumSkyblock.getInstance().getLogger().warning("FAWE version does not implement API correctly, did you miss an update? Disabling FAWE integration");
        }
        this.setPasterFromConfig();
        this.schematicFiles = new HashMap<String, File>();
        File parent = new File(IridiumSkyblock.getInstance().getDataFolder(), "schematics");
        for (File file : parent.listFiles()) {
            this.schematicFiles.put(file.getName(), file);
        }
    }

    public void reload() {
        this.loadCache();
        this.setPasterFromConfig();
        this.schematicPaster.clearCache();
    }

    private void setPasterFromConfig() {
        String paster = IridiumSkyblock.getInstance().getConfiguration().paster;
        if (this.availablePasters.containsKey(paster)) {
            this.schematicPaster = this.availablePasters.get(paster);
        } else {
            IridiumSkyblock.getInstance().getLogger().warning("Configuration error, selected paster [" + paster + "] is not available, available choices are " + this.availablePasters.keySet());
            this.schematicPaster = new SchematicAsync();
        }
    }

    public void loadCache() {
        this.schematicFiles.clear();
        File parent = new File(IridiumSkyblock.getInstance().getDataFolder(), "schematics");
        for (File file : parent.listFiles()) {
            this.schematicFiles.put(file.getName(), file);
        }
    }

    public CompletableFuture<Void> pasteSchematic(Island island, Schematics.SchematicConfig schematic) {
        ArrayList<CompletableFuture<Void>> completableFutures = new ArrayList<CompletableFuture<Void>>();
        if (IridiumSkyblock.getInstance().getConfiguration().enabledWorlds.getOrDefault(World.Environment.NORMAL, true).booleanValue()) {
            completableFutures.add(this.pasteSchematic(island, schematic.overworld, IridiumSkyblock.getInstance().getTeamManager().getWorld(World.Environment.NORMAL)));
        }
        if (IridiumSkyblock.getInstance().getConfiguration().enabledWorlds.getOrDefault(World.Environment.NETHER, true).booleanValue()) {
            completableFutures.add(this.pasteSchematic(island, schematic.nether, IridiumSkyblock.getInstance().getTeamManager().getWorld(World.Environment.NETHER)));
        }
        if (IridiumSkyblock.getInstance().getConfiguration().enabledWorlds.getOrDefault(World.Environment.THE_END, true).booleanValue()) {
            completableFutures.add(this.pasteSchematic(island, schematic.end, IridiumSkyblock.getInstance().getTeamManager().getWorld(World.Environment.THE_END)));
        }
        return CompletableFuture.runAsync(() -> completableFutures.forEach(CompletableFuture::join));
    }

    private CompletableFuture<Void> pasteSchematic(Island island, Schematics.SchematicWorld schematic, World world) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        Location location = island.getCenter(world);
        location.add(0.0, schematic.islandHeight.doubleValue(), 0.0);
        File file = this.schematicFiles.getOrDefault(schematic.schematicID, this.schematicFiles.values().stream().findFirst().orElse(null));
        Bukkit.getScheduler().runTask((Plugin)IridiumSkyblock.getInstance(), () -> {
            if (file == null) {
                location.getBlock().setType(Material.BEDROCK);
                IridiumSkyblock.getInstance().getLogger().warning("Could not find schematic " + schematic.schematicID);
            } else if (this.fawe) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)IridiumSkyblock.getInstance(), () -> this.schematicPaster.paste(file, location, schematic.ignoreAirBlocks, completableFuture));
            } else {
                this.schematicPaster.paste(file, location, schematic.ignoreAirBlocks, completableFuture);
            }
        });
        return completableFuture;
    }

    public boolean buy(Player player, Schematics.SchematicConfig schematic) {
        if (!this.canPurchase(player, schematic)) {
            player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().cannotAfford.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
            IridiumSkyblock.getInstance().getSchematics().failSound.play((Entity)player);
            return false;
        }
        this.purchase(player, schematic);
        return true;
    }

    private double getBankBalance(Player player, String bankItem) {
        User user = IridiumSkyblock.getInstance().getUserManager().getUser((OfflinePlayer)player);
        return IridiumSkyblock.getInstance().getTeamManager().getTeamViaID(user.getTeamID()).map(team -> IridiumSkyblock.getInstance().getTeamManager().getTeamBank((Island)team, bankItem)).map(TeamBank::getNumber).orElse(0.0);
    }

    private void setBankBalance(Player player, String bankItem, double amount) {
        User user = IridiumSkyblock.getInstance().getUserManager().getUser((OfflinePlayer)player);
        Optional<Island> team = IridiumSkyblock.getInstance().getTeamManager().getTeamViaID(user.getTeamID());
        if (!team.isPresent()) {
            return;
        }
        IridiumSkyblock.getInstance().getTeamManager().getTeamBank(team.get(), bankItem).setNumber(amount);
    }

    private boolean canPurchase(Player player, Schematics.SchematicConfig schematic) {
        double moneyCost = schematic.regenCost.money;
        Economy economy = IridiumSkyblock.getInstance().getEconomy();
        for (String bankItem : schematic.regenCost.bankItems.keySet()) {
            double cost = schematic.regenCost.bankItems.get(bankItem);
            if (!(this.getBankBalance(player, bankItem) < cost)) continue;
            return false;
        }
        return moneyCost == 0.0 || economy != null && economy.getBalance((OfflinePlayer)player) >= moneyCost;
    }

    private void purchase(Player player, Schematics.SchematicConfig schematic) {
        double moneyCost = schematic.regenCost.money;
        IridiumSkyblock.getInstance().getEconomy().withdrawPlayer((OfflinePlayer)player, moneyCost);
        for (String bankItem : schematic.regenCost.bankItems.keySet()) {
            double cost = schematic.regenCost.bankItems.get(bankItem);
            this.setBankBalance(player, bankItem, this.getBankBalance(player, bankItem) - cost);
        }
        IridiumSkyblock.getInstance().getSchematics().successSound.play((Entity)player);
    }

    public String formatPrice(double value) {
        if (IridiumSkyblock.getInstance().getSchematics().abbreviatePrices) {
            return IridiumSkyblock.getInstance().getConfiguration().numberFormatter.format(value);
        }
        return String.valueOf(value);
    }
}

