/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.api;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.annotations.Nullable;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Permission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.managers.TeamManager;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class IridiumSkyblockAPI {
    private static IridiumSkyblockAPI instance;
    private final IridiumSkyblock iridiumSkyblock;

    private IridiumSkyblockAPI(@NotNull IridiumSkyblock iridiumSkyblock) {
        this.iridiumSkyblock = iridiumSkyblock;
    }

    @Nullable
    public static IridiumSkyblockAPI getInstance() {
        if (instance == null && IridiumSkyblock.getInstance() != null) {
            instance = new IridiumSkyblockAPI(IridiumSkyblock.getInstance());
        }
        return instance;
    }

    public void addBankItem(@NotNull BankItem bankItem) {
        this.iridiumSkyblock.getBankItemList().add(bankItem);
    }

    public void addEnhancement(@NotNull String enhancementName, @NotNull Enhancement<?> enhancement) {
        this.iridiumSkyblock.addEnhancement(enhancementName, enhancement);
    }

    public void addPermission(@NotNull Permission permission, @NotNull String key) {
        this.iridiumSkyblock.getPermissionList().put(key, permission);
    }

    public void addCommand(@NotNull Command<Island, User> command) {
        this.iridiumSkyblock.getCommandManager().registerCommand(command);
    }

    @NotNull
    public User getUser(@NotNull OfflinePlayer offlinePlayer) {
        return this.iridiumSkyblock.getUserManager().getUser(offlinePlayer);
    }

    @NotNull
    public Optional<Island> getIslandById(int id) {
        return this.iridiumSkyblock.getIslandManager().getTeamViaID(id);
    }

    @NotNull
    public Optional<Island> getIslandByName(@NotNull String name) {
        return this.iridiumSkyblock.getIslandManager().getTeamViaName(name);
    }

    @NotNull
    public Optional<Island> getIslandViaLocation(@NotNull Location location) {
        return this.iridiumSkyblock.getIslandManager().getTeamViaLocation(location);
    }

    @NotNull
    public Optional<Permission> getPermissions(@NotNull String permissionKey) {
        return Optional.ofNullable(this.iridiumSkyblock.getPermissionList().get(permissionKey));
    }

    @NotNull
    public Optional<Permission> getPermissions(@NotNull PermissionType permissionType) {
        return this.getPermissions(permissionType.getPermissionKey());
    }

    public boolean getIslandPermission(@NotNull Island island, @NotNull User user, @NotNull Permission permission, @NotNull String key) {
        return this.iridiumSkyblock.getIslandManager().getTeamPermission(island, user, key);
    }

    public boolean getIslandPermission(@NotNull Island island, @NotNull User user, @NotNull PermissionType permissionType) {
        return this.iridiumSkyblock.getIslandManager().getTeamPermission(island, user, permissionType);
    }

    @NotNull
    public List<Island> getIslands(@NotNull TeamManager.SortType sortType) {
        return this.iridiumSkyblock.getIslandManager().getTeams(sortType, false);
    }

    @Nullable
    public World getWorld() {
        return this.iridiumSkyblock.getIslandManager().getWorld(World.Environment.NORMAL);
    }

    @Nullable
    public World getNetherWorld() {
        return this.iridiumSkyblock.getIslandManager().getWorld(World.Environment.NETHER);
    }

    @Nullable
    public World getEndWorld() {
        return this.iridiumSkyblock.getIslandManager().getWorld(World.Environment.THE_END);
    }

    public boolean isIslandWorld(@NotNull World world) {
        return this.iridiumSkyblock.getIslandManager().isInSkyblockWorld(world);
    }

    public boolean isIslandOverWorld(@NotNull World world) {
        return world.equals(this.getWorld());
    }

    public boolean isIslandNether(@NotNull World world) {
        return world.equals(this.getNetherWorld());
    }

    public boolean isIslandEnd(@NotNull World world) {
        return world.equals(this.getEndWorld());
    }

    public boolean canVisitIsland(@NotNull User user, @NotNull Island island) {
        return this.iridiumSkyblock.getIslandManager().canVisit(user.getPlayer(), island);
    }
}

