/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.commands;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Schematics;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.ConfirmableCommand;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import com.iridium.iridiumskyblock.gui.RegenGUI;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RegenCommand
extends ConfirmableCommand<Island, User> {
    public RegenCommand() {
        super(Collections.singletonList("regen"), "Regenerate your Island", "%prefix% &7/is regen <schematic>", "", 300L, true);
    }

    @Override
    protected void executeAfterConfirmation(User user, Island island, String[] args, IridiumTeams<Island, User> iridiumTeams) {
        Player player = user.getPlayer();
        if (args.length == 0 && IridiumSkyblock.getInstance().getSchematics().schematics.size() > 1) {
            return;
        }
        Optional<String> schematic = IridiumSkyblock.getInstance().getSchematics().schematics.keySet().stream().filter(config -> IridiumSkyblock.getInstance().getSchematics().schematics.size() == 1 || config.equalsIgnoreCase(args[0])).findFirst();
        if (!schematic.isPresent()) {
            return;
        }
        Schematics.SchematicConfig schematicConfig = IridiumSkyblock.getInstance().getSchematics().schematics.get(schematic.get());
        if (!(schematicConfig.regenCost.money == 0.0 && schematicConfig.regenCost.bankItems.isEmpty() || IridiumSkyblock.getInstance().getSchematicManager().buy(player, schematicConfig))) {
            return;
        }
        List bankPlaceholders = IridiumSkyblock.getInstance().getBankItemList().stream().map(BankItem::getName).map(name -> new Placeholder(name + "_cost", this.formatPrice(this.getBankBalance(player, (String)name)))).collect(Collectors.toList());
        IridiumSkyblock.getInstance().getIslandManager().getTeamMembers(island).stream().map(IridiumUser::getPlayer).filter(Objects::nonNull).forEach(member -> member.sendMessage(StringUtils.color(StringUtils.processMultiplePlaceholders(IridiumSkyblock.getInstance().getMessages().paidForRegen.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix).replace("%player%", player.getName()).replace("%schematic%", StringUtils.color(schematicConfig.item.displayName)).replace("%vault_cost%", this.formatPrice(schematicConfig.regenCost.money)), (List<Placeholder>)bankPlaceholders))));
        player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().regeneratingIsland.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
        IridiumSkyblock.getInstance().getIslandManager().clearTeamInventory(island);
        IridiumSkyblock.getInstance().getIslandManager().generateIsland(island, schematicConfig).thenRun(() -> Bukkit.getScheduler().runTask((Plugin)IridiumSkyblock.getInstance(), () -> {
            if (IridiumSkyblock.getInstance().getTeamManager().teleport(player, island.getHome(), island)) {
                player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().teleportingHome.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
            }
        }));
    }

    private double getBankBalance(Player player, String bankItem) {
        User user = IridiumSkyblock.getInstance().getUserManager().getUser((OfflinePlayer)player);
        return IridiumSkyblock.getInstance().getTeamManager().getTeamViaID(user.getTeamID()).map(team -> IridiumSkyblock.getInstance().getTeamManager().getTeamBank((Island)team, bankItem)).map(TeamBank::getNumber).orElse(0.0);
    }

    private double round(double value, int places) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        bigDecimal = bigDecimal.setScale(places, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public String formatPrice(double value) {
        value = this.round(value, 2);
        if (IridiumSkyblock.getInstance().getSchematics().abbreviatePrices) {
            return IridiumSkyblock.getInstance().getConfiguration().numberFormatter.format(value);
        }
        return String.valueOf(value);
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<Island, User> iridiumTeams) {
        return new ArrayList<String>(IridiumSkyblock.getInstance().getSchematics().schematics.keySet());
    }

    @Override
    protected boolean isCommandValid(User user, Island island, String[] args, IridiumTeams<Island, User> iridiumTeams) {
        Player player = user.getPlayer();
        if (!IridiumSkyblock.getInstance().getIslandManager().getTeamPermission(island, IridiumSkyblock.getInstance().getUserManager().getUser((OfflinePlayer)player), "regen")) {
            player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().cannotRegenIsland.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
            return false;
        }
        if (args.length == 0 && IridiumSkyblock.getInstance().getSchematics().schematics.size() > 1) {
            player.openInventory(new RegenGUI(player).getInventory());
            return false;
        }
        Optional<String> schematic = IridiumSkyblock.getInstance().getSchematics().schematics.keySet().stream().filter(config -> IridiumSkyblock.getInstance().getSchematics().schematics.size() == 1 || config.equalsIgnoreCase(args[0])).findFirst();
        if (!schematic.isPresent()) {
            player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().unknownSchematic.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
            return false;
        }
        Schematics.SchematicConfig schematicConfig = IridiumSkyblock.getInstance().getSchematics().schematics.get(schematic.get());
        if (island.getLevel() < schematicConfig.minLevel) {
            player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().notHighEnoughLevel.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix).replace("%level%", String.valueOf(schematicConfig.minLevel))));
            return false;
        }
        if (schematicConfig.regenCost.money != 0.0 || !schematicConfig.regenCost.bankItems.isEmpty()) {
            return IridiumSkyblock.getInstance().getSchematicManager().buy(player, schematicConfig);
        }
        return true;
    }
}

