/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.database;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.DatabaseObject;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DataType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseField;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.DatabaseTable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;

@DatabaseTable(tableName="lost_items")
public class LostItems
extends DatabaseObject {
    @DatabaseField(columnName="id", generatedId=true, canBeNull=false, unique=true)
    private int id;
    @DatabaseField(columnName="uuid", canBeNull=false)
    @NotNull
    private UUID uuid;
    @DatabaseField(columnName="time")
    private LocalDateTime time;
    @DatabaseField(columnName="items", dataType=DataType.SERIALIZABLE)
    private String[] items;

    public void setItems(ItemStack[] items) {
        this.items = (String[])Arrays.stream(items).map(ItemStackUtils::serialize).toArray(String[]::new);
    }

    public ItemStack[] getItems() {
        return (ItemStack[])Arrays.stream(this.items).map(ItemStackUtils::deserialize).toArray(ItemStack[]::new);
    }

    public LostItems(@NotNull UUID uuid, ItemStack[] items) {
        this.uuid = uuid;
        this.time = LocalDateTime.now();
        this.setItems(items);
    }

    @Generated
    public LostItems() {
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public LocalDateTime getTime() {
        return this.time;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setUuid(@NotNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.uuid = uuid;
    }

    @Generated
    public void setTime(LocalDateTime time) {
        this.time = time;
    }
}

