/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumcore;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.XSeriesSerialSupplier;
import com.iridium.iridiumskyblock.dependencies.jackson.core.JsonFactory;
import com.iridium.iridiumskyblock.dependencies.jackson.core.JsonParser;
import com.iridium.iridiumskyblock.dependencies.jackson.databind.ObjectMapper;
import com.iridium.iridiumskyblock.dependencies.jackson.databind.module.SimpleModule;
import com.iridium.iridiumskyblock.dependencies.jackson.dataformat.yaml.YAMLFactory;
import com.iridium.iridiumskyblock.dependencies.xseries.XBiome;
import com.iridium.iridiumskyblock.dependencies.xseries.XEnchantment;
import com.iridium.iridiumskyblock.dependencies.xseries.XEntityType;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import com.iridium.iridiumskyblock.dependencies.xseries.XPotion;
import com.iridium.iridiumskyblock.dependencies.xseries.XSound;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Persist {
    private final ObjectMapper objectMapper;
    private final PersistType persistType;
    private final JavaPlugin javaPlugin;

    public Persist(PersistType persistType, JavaPlugin javaPlugin) {
        this.persistType = persistType;
        this.javaPlugin = javaPlugin;
        this.objectMapper = new ObjectMapper(persistType.getFactory()).configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
        SimpleModule xSeriesModule = new SimpleModule();
        xSeriesModule.addSerializer(XMaterial.class, new XSeriesSerialSupplier.XMaterialSerializer());
        xSeriesModule.addDeserializer(XMaterial.class, new XSeriesSerialSupplier.XMaterialDeserializer());
        xSeriesModule.addSerializer(XPotion.class, new XSeriesSerialSupplier.XPotionSerializer());
        xSeriesModule.addDeserializer(XPotion.class, new XSeriesSerialSupplier.XPotionDeserializer());
        xSeriesModule.addSerializer(XEnchantment.class, new XSeriesSerialSupplier.XEnchantmentSerializer());
        xSeriesModule.addDeserializer(XEnchantment.class, new XSeriesSerialSupplier.XEnchantmentDeserializer());
        xSeriesModule.addSerializer(XBiome.class, new XSeriesSerialSupplier.XBiomeSerializer());
        xSeriesModule.addDeserializer(XBiome.class, new XSeriesSerialSupplier.XBiomeDeserializer());
        xSeriesModule.addSerializer(XSound.class, new XSeriesSerialSupplier.XSoundSerializer());
        xSeriesModule.addDeserializer(XSound.class, new XSeriesSerialSupplier.XSoundDeserializer());
        xSeriesModule.addSerializer(XEntityType.class, new XSeriesSerialSupplier.XEntityTypeSerializer());
        xSeriesModule.addDeserializer(XEntityType.class, new XSeriesSerialSupplier.XEntityTypeDeserializer());
        this.objectMapper.registerModule(xSeriesModule);
    }

    private static String getName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    public static String getName(Object instance) {
        return Persist.getName(instance.getClass());
    }

    public static String getName(Type type) {
        return Persist.getName(type.getClass());
    }

    public File getFile(String name) {
        return new File(this.javaPlugin.getDataFolder(), name + this.persistType.getExtension());
    }

    public File getFile(Class<?> clazz) {
        return this.getFile(Persist.getName(clazz));
    }

    public File getFile(Object instance) {
        return this.getFile(Persist.getName(instance));
    }

    public void save(Object instance) {
        this.save(instance, this.getFile(instance));
    }

    private void save(Object instance, File file) {
        try {
            this.objectMapper.writeValue(file, instance);
        }
        catch (IOException e) {
            this.javaPlugin.getLogger().severe("Failed to save " + file.toString() + ": " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this.javaPlugin);
        }
    }

    public String toString(Object instance) {
        try {
            return this.objectMapper.writeValueAsString(instance);
        }
        catch (IOException e) {
            this.javaPlugin.getLogger().severe("Failed to save " + instance.toString() + ": " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this.javaPlugin);
            return "";
        }
    }

    public <T> T load(Class<T> clazz) {
        return this.load(clazz, this.getFile(clazz));
    }

    public <T> T load(Class<T> clazz, File file) {
        if (file.exists()) {
            try {
                return this.objectMapper.readValue(file, clazz);
            }
            catch (IOException e) {
                this.javaPlugin.getLogger().severe("Failed to parse " + file + ": " + e.getMessage());
                this.javaPlugin.getLogger().severe("Creating a backup for " + file.getName() + " in \"backups\" folder...");
                String backupFolderName = "backups";
                File pluginFolder = new File(this.javaPlugin.getDataFolder().getPath());
                File backupFolder = new File(pluginFolder.getPath() + File.separator + backupFolderName);
                File backupConfigFile = new File(backupFolder + File.separator + file.getName());
                try {
                    if (!backupFolder.exists()) {
                        backupFolder.mkdir();
                    }
                    Files.copy(file.toPath(), backupConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(file.toPath());
                    this.javaPlugin.getLogger().info("Success! Backup \"" + file.getName() + "\" created, check \"" + backupFolder.getPath() + "\".");
                }
                catch (IOException exception) {
                    this.javaPlugin.getLogger().severe("Failed to move " + file + " to " + this.javaPlugin.getDataFolder().getName() + File.separator + "backups: " + exception.getMessage());
                    Bukkit.getPluginManager().disablePlugin((Plugin)this.javaPlugin);
                }
                this.load(clazz, file);
            }
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T load(Class<T> clazz, String content) {
        try {
            return this.objectMapper.readValue(content, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this.javaPlugin);
            return null;
        }
    }

    public static enum PersistType {
        YAML(".yml", new YAMLFactory()),
        JSON(".json", new JsonFactory());

        private final String extension;
        private final JsonFactory factory;

        private PersistType(String extension, JsonFactory factory) {
            this.extension = extension;
            this.factory = factory;
        }

        public String getExtension() {
            return this.extension;
        }

        public JsonFactory getFactory() {
            return this.factory;
        }
    }
}

