/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.ConfirmationGUI;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class ConfirmableCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public final boolean requiresConfirmation;

    public ConfirmableCommand() {
        this.requiresConfirmation = true;
    }

    public ConfirmableCommand(@NotNull List<String> aliases, @NotNull String description, @NotNull String syntax, @NotNull String permission, long cooldownInSeconds, boolean requiresConfirmation) {
        super(aliases, description, syntax, permission, cooldownInSeconds);
        this.requiresConfirmation = requiresConfirmation;
    }

    @Override
    public final boolean execute(U user, T team, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        if (!this.isCommandValid(user, team, arguments, iridiumTeams)) {
            return false;
        }
        if (this.requiresConfirmation) {
            Player player = ((IridiumUser)user).getPlayer();
            player.openInventory(new ConfirmationGUI<T, U>(() -> this.executeAfterConfirmation(user, team, arguments, iridiumTeams), iridiumTeams).getInventory());
            return true;
        }
        this.executeAfterConfirmation(user, team, arguments, iridiumTeams);
        return true;
    }

    protected abstract boolean isCommandValid(U var1, T var2, String[] var3, IridiumTeams<T, U> var4);

    protected abstract void executeAfterConfirmation(U var1, T var2, String[] var3, IridiumTeams<T, U> var4);
}

