/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.entity.Player;

public class DescriptionCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public String adminPermission;

    public DescriptionCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds, String adminPermission) {
        super(args, description, syntax, permission, cooldownInSeconds);
        this.adminPermission = adminPermission;
    }

    @Override
    public boolean execute(U user, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length == 0) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        Optional<T> team = iridiumTeams.getTeamManager().getTeamViaNameOrPlayer(args[0]);
        if (team.isPresent() && player.hasPermission(this.adminPermission)) {
            String description = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            this.changeDescription((Team)team.get(), description, player, iridiumTeams);
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().changedPlayerDescription.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%name%", ((Team)team.get()).getName()).replace("%description%", description)));
            return true;
        }
        return super.execute(user, args, iridiumTeams);
    }

    @Override
    public boolean execute(U user, T team, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (!iridiumTeams.getTeamManager().getTeamPermission(team, user, PermissionType.DESCRIPTION)) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotChangeDescription.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        this.changeDescription(team, String.join((CharSequence)" ", arguments), player, iridiumTeams);
        return true;
    }

    private void changeDescription(T team, String description, Player player, IridiumTeams<T, U> iridiumTeams) {
        ((Team)team).setDescription(description);
        iridiumTeams.getTeamManager().getTeamMembers(team).stream().map(IridiumUser::getPlayer).filter(Objects::nonNull).forEach(member -> member.sendMessage(StringUtils.color(iridiumTeams.getMessages().descriptionChanged.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", player.getName()).replace("%description%", description))));
    }

    @Generated
    public DescriptionCommand() {
    }
}

