/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.BankGUI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ExperienceCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public String adminPermission;

    public ExperienceCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds, String adminPermission) {
        super(args, description, syntax, permission, cooldownInSeconds);
        this.adminPermission = adminPermission;
    }

    @Override
    public boolean execute(CommandSender sender, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        if (arguments.length == 3) {
            int amount;
            Optional<T> team = iridiumTeams.getTeamManager().getTeamViaNameOrPlayer(arguments[1]);
            if (!team.isPresent()) {
                sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().teamDoesntExistByName.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            try {
                amount = Integer.parseInt(arguments[2]);
            }
            catch (NumberFormatException exception) {
                sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().notANumber.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            if (!sender.hasPermission(this.adminPermission)) {
                sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().noPermission.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
                return false;
            }
            switch (arguments[0].toLowerCase()) {
                case "give": {
                    sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().gaveExperience.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", arguments[1]).replace("%amount%", String.valueOf(amount))));
                    ((Team)team.get()).setExperience(((Team)team.get()).getExperience() + amount);
                    return true;
                }
                case "remove": {
                    sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().removedExperience.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", arguments[1]).replace("%amount%", String.valueOf(Math.min(amount, ((Team)team.get()).getExperience())))));
                    ((Team)team.get()).setExperience(((Team)team.get()).getExperience() - amount);
                    return true;
                }
                case "set": {
                    sender.sendMessage(StringUtils.color(iridiumTeams.getMessages().setExperience.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", arguments[1]).replace("%amount%", String.valueOf(Math.max(amount, 0)))));
                    ((Team)team.get()).setExperience(amount);
                    return true;
                }
            }
            sender.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (arguments.length != 0) {
            sender.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        return iridiumTeams.getCommandManager().executeCommand(sender, iridiumTeams.getCommands().infoCommand, arguments);
    }

    @Override
    public boolean execute(U user, T team, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        player.openInventory(new BankGUI<T, U>(team, player, iridiumTeams).getInventory());
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        if (!commandSender.hasPermission(this.adminPermission)) {
            return Collections.emptyList();
        }
        switch (args.length) {
            case 1: {
                return Arrays.asList("give", "set", "remove");
            }
            case 2: {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            }
            case 3: {
                return Arrays.asList("1", "10", "100");
            }
        }
        return Collections.emptyList();
    }

    @Generated
    public ExperienceCommand() {
    }
}

