/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.LogType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KickCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public KickCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (args.length != 1) {
            player.sendMessage(StringUtils.color(this.syntax.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (!iridiumTeams.getTeamManager().getTeamPermission(team, user, PermissionType.KICK)) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotKick.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        OfflinePlayer offlinePlayer = Bukkit.getServer().getOfflinePlayer(args[0]);
        Object kickedPlayer = iridiumTeams.getUserManager().getUser(offlinePlayer);
        if (((Team)team).getId() != ((IridiumUser)kickedPlayer).getTeamID()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().userNotInYourTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (offlinePlayer.getUniqueId() == player.getUniqueId()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotKickYourself.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        if (!(((IridiumUser)kickedPlayer).getUserRank() < ((IridiumUser)user).getUserRank() && ((IridiumUser)kickedPlayer).getUserRank() != Rank.OWNER.getId() || ((IridiumUser)user).isBypassing() || ((IridiumUser)user).getUserRank() == Rank.OWNER.getId())) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().cannotKickHigherRank.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        ((IridiumUser)kickedPlayer).setTeam(null);
        Optional.ofNullable(((IridiumUser)kickedPlayer).getPlayer()).ifPresent(player1 -> player1.sendMessage(StringUtils.color(iridiumTeams.getMessages().youHaveBeenKicked.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", player.getName()))));
        iridiumTeams.getTeamManager().getTeamMembers(team).stream().map(IridiumUser::getPlayer).filter(Objects::nonNull).forEach(player1 -> player1.sendMessage(StringUtils.color(iridiumTeams.getMessages().playerKicked.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%player%", kickedPlayer.getName()).replace("%kicker%", player.getName()))));
        iridiumTeams.getTeamManager().saveTeamLog(new TeamLog((Team)team, LogType.TEAM_KICK, iridiumTeams.getTeamLogs().teamKickLogDescription, ((IridiumUser)kickedPlayer).getUuid(), ((IridiumUser)user).getUuid()));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
    }

    @Generated
    public KickCommand() {
    }
}

