/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.LogType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LeaveCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public LeaveCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (((IridiumUser)user).getUserRank() == Rank.OWNER.getId()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().ownerCannotLeave.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        player.sendMessage(StringUtils.color(iridiumTeams.getMessages().leftTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%name%", ((Team)team).getName())));
        iridiumTeams.getTeamManager().getTeamMembers(team).forEach(teamUser -> {
            Player teamPlayer = Bukkit.getPlayer((UUID)teamUser.getUuid());
            if (teamPlayer != null && teamPlayer != player) {
                teamPlayer.sendMessage(StringUtils.color(iridiumTeams.getMessages().userLeftTeam.replace("%prefix%", iridiumTeams.getConfiguration().prefix).replace("%name%", team.getName()).replace("%player%", player.getName())));
            }
        });
        iridiumTeams.getTeamManager().saveTeamLog(new TeamLog((Team)team, LogType.TEAM_LEAVE, iridiumTeams.getTeamLogs().teamLeaveLogDescription, ((IridiumUser)user).getUuid()));
        ((IridiumUser)user).setTeam(null);
        return true;
    }

    @Generated
    public LeaveCommand() {
    }
}

