/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamLog;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LogsCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public LogsCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Object actionFilter = null;
        Object userFilter = null;
        iridiumTeams.getTeamManager().getTeamLogsMaxPage(team, 8, null, null).thenAccept(maxPage -> Bukkit.getScheduler().runTask((Plugin)iridiumTeams, () -> {
            String pageArgument;
            int page = 1;
            if (args.length != 0 && (pageArgument = args[0]).matches("[0-9]+")) {
                page = Integer.parseInt(pageArgument);
            }
            if (page > maxPage) {
                page = maxPage;
            } else if (page < 1) {
                page = 1;
            }
            int finalPage = page;
            iridiumTeams.getTeamManager().getTeamLogs((Team)team, 8, page, null, null).thenAccept(teamLogs -> Bukkit.getScheduler().runTask((Plugin)iridiumTeams, () -> {
                List<TeamLog> processedTeamLogs = iridiumTeams.getTeamManager().processTeamLogs((List<TeamLog>)teamLogs);
                Player player = user.getPlayer();
                TextComponent footerText = new TextComponent(StringUtils.color(iridiumTeams.getTeamLogs().teamLogFooter.replace("%page%", String.valueOf(finalPage)).replace("%max_page%", String.valueOf(maxPage))));
                TextComponent previousButton = new TextComponent(StringUtils.color(iridiumTeams.getTeamLogs().teamLogPreviousPage));
                TextComponent nextButton = new TextComponent(StringUtils.color(iridiumTeams.getTeamLogs().teamLogNextPage));
                if (finalPage != 1) {
                    previousButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + iridiumTeams.getCommandManager().getCommand() + " logs " + (finalPage - 1)));
                    previousButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringUtils.color(iridiumTeams.getTeamLogs().teamLogPreviousPageHover)).create()));
                }
                if (finalPage != maxPage) {
                    nextButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + iridiumTeams.getCommandManager().getCommand() + " logs " + (finalPage + 1)));
                    nextButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringUtils.color(iridiumTeams.getTeamLogs().teamLogNextPageHover)).create()));
                }
                player.sendMessage(StringUtils.color(StringUtils.getCenteredMessage(iridiumTeams.getTeamLogs().teamLogHeader, iridiumTeams.getTeamLogs().teamLogFiller)));
                processedTeamLogs.stream().map(teamLog -> StringUtils.color(iridiumTeams.getTeamLogs().teamLogMessage.replace("%date%", teamLog.getTime().format(DateTimeFormatter.ofPattern(iridiumTeams.getTeamLogs().teamLogDateTimeFormat))).replace("%description%", teamLog.getDescription()))).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
                player.spigot().sendMessage(new BaseComponent[]{previousButton, footerText, nextButton});
            }));
        }));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        return new ArrayList<String>();
    }

    @Generated
    public LogsCommand() {
    }
}

