/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.MissionTypeSelectorInventoryConfig;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.MissionGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.MissionTypeSelectorGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.MissionType;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MissionsCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public MissionsCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, T team, String[] args, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        MissionTypeSelectorInventoryConfig missionTypeSelectorInventoryConfig = iridiumTeams.getInventories().missionTypeSelectorGUI;
        if (args.length == 1) {
            switch (args[0].toLowerCase()) {
                case "daily": {
                    if (missionTypeSelectorInventoryConfig.daily.enabled) {
                        player.openInventory(new MissionGUI<T, U>(team, MissionType.DAILY, player, iridiumTeams).getInventory());
                    } else {
                        player.openInventory(new MissionTypeSelectorGUI<T, U>(player, iridiumTeams).getInventory());
                    }
                    return true;
                }
                case "weekly": {
                    if (missionTypeSelectorInventoryConfig.weekly.enabled) {
                        player.openInventory(new MissionGUI<T, U>(team, MissionType.WEEKLY, player, iridiumTeams).getInventory());
                    } else {
                        player.openInventory(new MissionTypeSelectorGUI<T, U>(player, iridiumTeams).getInventory());
                    }
                    return true;
                }
                case "infinite": {
                    if (missionTypeSelectorInventoryConfig.infinite.enabled) {
                        player.openInventory(new MissionGUI<T, U>(team, MissionType.INFINITE, player, iridiumTeams).getInventory());
                    } else {
                        player.openInventory(new MissionTypeSelectorGUI<T, U>(player, iridiumTeams).getInventory());
                    }
                    return true;
                }
                case "once": {
                    if (missionTypeSelectorInventoryConfig.once.enabled) {
                        player.openInventory(new MissionGUI<T, U>(team, MissionType.ONCE, player, iridiumTeams).getInventory());
                    } else {
                        player.openInventory(new MissionTypeSelectorGUI<T, U>(player, iridiumTeams).getInventory());
                    }
                    return true;
                }
            }
        }
        player.openInventory(new MissionTypeSelectorGUI<T, U>(player, iridiumTeams).getInventory());
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] args, IridiumTeams<T, U> iridiumTeams) {
        MissionTypeSelectorInventoryConfig missionTypeSelectorInventoryConfig = iridiumTeams.getInventories().missionTypeSelectorGUI;
        ArrayList<String> missionTypes = new ArrayList<String>();
        if (missionTypeSelectorInventoryConfig.daily.enabled) {
            missionTypes.add("Daily");
        }
        if (missionTypeSelectorInventoryConfig.weekly.enabled) {
            missionTypes.add("Weekly");
        }
        if (missionTypeSelectorInventoryConfig.infinite.enabled) {
            missionTypes.add("Infinite");
        }
        if (missionTypeSelectorInventoryConfig.once.enabled) {
            missionTypes.add("Once");
        }
        return missionTypes;
    }

    @Generated
    public MissionsCommand() {
    }
}

