/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.commands;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.commands.Command;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.ShopCategoryGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.ShopOverviewGUI;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.entity.Player;

public class ShopCommand<T extends Team, U extends IridiumUser<T>>
extends Command<T, U> {
    public ShopCommand(List<String> args, String description, String syntax, String permission, long cooldownInSeconds) {
        super(args, description, syntax, permission, cooldownInSeconds);
    }

    @Override
    public boolean execute(U user, String[] arguments, IridiumTeams<T, U> iridiumTeams) {
        Player player = ((IridiumUser)user).getPlayer();
        if (arguments.length == 0) {
            player.openInventory(new ShopOverviewGUI<T, U>(player, iridiumTeams).getInventory());
            return true;
        }
        Optional<String> categoryName = this.getCategoryName(String.join((CharSequence)" ", arguments), iridiumTeams);
        if (!categoryName.isPresent()) {
            player.sendMessage(StringUtils.color(iridiumTeams.getMessages().noShopCategory.replace("%prefix%", iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        player.openInventory(new ShopCategoryGUI<T, U>(categoryName.get(), player, 1, iridiumTeams).getInventory());
        return true;
    }

    private Optional<String> getCategoryName(String name, IridiumTeams<T, U> iridiumTeams) {
        for (String category : iridiumTeams.getShop().categories.keySet()) {
            if (!category.equalsIgnoreCase(name)) continue;
            return Optional.of(category);
        }
        return Optional.empty();
    }

    @Generated
    public ShopCommand() {
    }
}

