/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.database;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.LogType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DatabaseField;
import com.iridium.iridiumskyblock.dependencies.ormlite.table.DatabaseTable;
import java.time.LocalDateTime;
import java.util.UUID;
import lombok.Generated;

@DatabaseTable(tableName="team_log")
public class TeamLog {
    @DatabaseField(columnName="id", generatedId=true, canBeNull=false)
    private int id;
    @DatabaseField(columnName="team_id", canBeNull=false)
    private int teamID;
    @DatabaseField(columnName="time", canBeNull=false)
    private LocalDateTime time;
    @DatabaseField(columnName="user")
    private UUID user;
    @DatabaseField(columnName="other_user")
    private UUID otherUser;
    @DatabaseField(columnName="action", canBeNull=false)
    private LogType action;
    @DatabaseField(columnName="description", canBeNull=false)
    private String description;

    public TeamLog(@NotNull Team team, LogType action, String description) {
        this.teamID = team.getId();
        this.time = LocalDateTime.now();
        this.action = action;
        this.description = description;
    }

    public TeamLog(@NotNull Team team, LogType action, String description, UUID user) {
        this(team, action, description);
        this.user = user;
    }

    public TeamLog(@NotNull Team team, LogType action, String description, UUID user, UUID otherUser) {
        this(team, action, description);
        this.user = user;
        this.otherUser = otherUser;
    }

    public TeamLog(TeamLog teamLog, String description) {
        this.teamID = teamLog.getTeamID();
        this.time = teamLog.getTime();
        this.action = teamLog.getAction();
        this.description = description;
        this.user = teamLog.getUser();
        this.otherUser = teamLog.getOtherUser();
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public int getTeamID() {
        return this.teamID;
    }

    @Generated
    public LocalDateTime getTime() {
        return this.time;
    }

    @Generated
    public UUID getUser() {
        return this.user;
    }

    @Generated
    public UUID getOtherUser() {
        return this.otherUser;
    }

    @Generated
    public LogType getAction() {
        return this.action;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public TeamLog() {
    }
}

