/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.dependencies.updatechecker;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.dependencies.updatechecker.UpdateCheckEvent;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.dependencies.updatechecker.UpdateChecker;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.dependencies.updatechecker.UpdateCheckerMessages;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

class UpdateCheckListener
implements Listener {
    private final UpdateChecker instance = UpdateChecker.getInstance();

    UpdateCheckListener() {
    }

    @EventHandler
    public void notifyOnJoin(PlayerJoinEvent playerJoinEvent) {
        if (!this.instance.isCheckedAtLeastOnce()) {
            return;
        }
        Player player = playerJoinEvent.getPlayer();
        if (player.isOp() && this.instance.isNotifyOpsOnJoin() || this.instance.getNotifyPermission() != null && player.hasPermission(this.instance.getNotifyPermission())) {
            UpdateCheckerMessages.printCheckResultToPlayer(player, false);
        }
    }

    @EventHandler
    public void onUpdateCheck(UpdateCheckEvent event) {
        if (!this.instance.isCheckedAtLeastOnce()) {
            return;
        }
        if (!this.instance.isNotifyRequesters()) {
            return;
        }
        if (event.getRequesters() == null) {
            return;
        }
        for (CommandSender commandSender : event.getRequesters()) {
            if (commandSender instanceof Player) {
                UpdateCheckerMessages.printCheckResultToPlayer((Player)commandSender, true);
                continue;
            }
            UpdateCheckerMessages.printCheckResultToConsole(event);
        }
    }
}

