/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.bank.BankItem;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import java.util.Collections;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class BankGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final T team;
    private final IridiumTeams<T, U> iridiumTeams;

    public BankGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().bankGUI.background, player, iridiumTeams.getInventories().backButton);
        this.team = team;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        NoItemGUI noItemGUI = this.iridiumTeams.getInventories().bankGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)noItemGUI.size, (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (BankItem bankItem : this.iridiumTeams.getBankItemList()) {
            TeamBank teamBank = this.iridiumTeams.getTeamManager().getTeamBank(this.team, bankItem.getName());
            inventory.setItem(bankItem.getItem().slot.intValue(), ItemStackUtils.makeItem(bankItem.getItem(), Collections.singletonList(new Placeholder("amount", this.iridiumTeams.getConfiguration().numberFormatter.format(teamBank.getNumber())))));
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        Optional<BankItem> bankItem = this.iridiumTeams.getBankItemList().stream().filter(item -> item.getItem().slot.intValue() == event.getSlot()).findFirst();
        if (!bankItem.isPresent()) {
            return;
        }
        switch (event.getClick()) {
            case LEFT: {
                this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().withdrawCommand, new String[]{bankItem.get().getName(), String.valueOf(bankItem.get().getDefaultAmount())});
                break;
            }
            case RIGHT: {
                this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().depositCommand, new String[]{bankItem.get().getName(), String.valueOf(bankItem.get().getDefaultAmount())});
                break;
            }
            case SHIFT_LEFT: {
                this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().withdrawCommand, new String[]{bankItem.get().getName(), String.valueOf(Double.MAX_VALUE)});
                break;
            }
            case SHIFT_RIGHT: {
                this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().depositCommand, new String[]{bankItem.get().getName(), String.valueOf(Double.MAX_VALUE)});
            }
        }
        this.addContent(event.getInventory());
    }
}

