/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.UserRank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.gui.PermissionsGUI;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class RanksGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final IridiumTeams<T, U> iridiumTeams;
    private final T team;

    public RanksGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().ranksGUI.background, player, iridiumTeams.getInventories().backButton);
        this.team = team;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.iridiumTeams.getInventories().ranksGUI.size, (String)StringUtils.color(this.iridiumTeams.getInventories().ranksGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (UserRank userRank : this.iridiumTeams.getUserRanks().values()) {
            inventory.setItem(userRank.item.slot.intValue(), ItemStackUtils.makeItem(userRank.item));
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        for (Map.Entry<Integer, UserRank> userRank : this.iridiumTeams.getUserRanks().entrySet()) {
            if (event.getSlot() != userRank.getValue().item.slot.intValue()) continue;
            event.getWhoClicked().openInventory(new PermissionsGUI<T, U>(this.team, userRank.getKey(), (Player)event.getWhoClicked(), this.iridiumTeams).getInventory());
            return;
        }
    }
}

