/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.Item;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.PagedGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.SingleItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamReward;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class RewardsGUI<T extends Team, U extends IridiumUser<T>>
extends PagedGUI<TeamReward> {
    private final IridiumTeams<T, U> iridiumTeams;
    private final T team;

    public RewardsGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(1, iridiumTeams.getInventories().rewardsGUI.size, iridiumTeams.getInventories().rewardsGUI.background, iridiumTeams.getInventories().previousPage, iridiumTeams.getInventories().nextPage, player, iridiumTeams.getInventories().backButton);
        this.iridiumTeams = iridiumTeams;
        this.team = team;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        Item item = this.iridiumTeams.getInventories().rewardsGUI.item;
        inventory.setItem(item.slot.intValue(), ItemStackUtils.makeItem(item));
    }

    @NotNull
    public Inventory getInventory() {
        SingleItemGUI noItemGUI = this.iridiumTeams.getInventories().rewardsGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public Collection<TeamReward> getPageObjects() {
        return this.iridiumTeams.getTeamManager().getTeamRewards(this.team);
    }

    @Override
    public ItemStack getItemStack(TeamReward teamReward) {
        return ItemStackUtils.makeItem(teamReward.getReward().item);
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        if (event.getSlot() == this.iridiumTeams.getInventories().rewardsGUI.item.slot.intValue()) {
            for (TeamReward teamReward : this.getPageObjects()) {
                this.iridiumTeams.getTeamManager().claimTeamReward(teamReward, (Player)event.getWhoClicked());
            }
            return;
        }
        TeamReward teamReward = (TeamReward)this.getItem(event.getSlot());
        if (teamReward == null) {
            return;
        }
        this.iridiumTeams.getTeamManager().claimTeamReward(teamReward, (Player)event.getWhoClicked());
    }
}

