/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.PagedGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.SingleItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamTrust;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class TrustsGUI<T extends Team, U extends IridiumUser<T>>
extends PagedGUI<TeamTrust> {
    private final T team;
    private final IridiumTeams<T, U> iridiumTeams;

    public TrustsGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(1, iridiumTeams.getInventories().trustsGUI.size, iridiumTeams.getInventories().trustsGUI.background, iridiumTeams.getInventories().previousPage, iridiumTeams.getInventories().nextPage, player, iridiumTeams.getInventories().backButton);
        this.team = team;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        SingleItemGUI noItemGUI = this.iridiumTeams.getInventories().trustsGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public Collection<TeamTrust> getPageObjects() {
        return this.iridiumTeams.getTeamManager().getTeamTrusts(this.team);
    }

    @Override
    public ItemStack getItemStack(TeamTrust teamTrust) {
        Optional<U> user = this.iridiumTeams.getUserManager().getUserByUUID(teamTrust.getUser());
        Optional<String> truster = this.iridiumTeams.getUserManager().getUserByUUID(teamTrust.getTruster());
        ArrayList<Placeholder> placeholderList = new ArrayList<Placeholder>(this.iridiumTeams.getUserPlaceholderBuilder().getPlaceholders(user));
        placeholderList.add(new Placeholder("trusted_time", teamTrust.getTime().format(DateTimeFormatter.ofPattern(this.iridiumTeams.getConfiguration().dateTimeFormat))));
        placeholderList.add(new Placeholder("truster", truster.map(IridiumUser::getName).orElse(this.iridiumTeams.getMessages().nullPlaceholder)));
        return ItemStackUtils.makeItem(this.iridiumTeams.getInventories().trustsGUI.item, placeholderList);
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        TeamTrust teamTrust = (TeamTrust)this.getItem(event.getSlot());
        if (teamTrust == null) {
            return;
        }
        String username = this.iridiumTeams.getUserManager().getUserByUUID(teamTrust.getUser()).map(IridiumUser::getName).orElse(this.iridiumTeams.getMessages().nullPlaceholder);
        this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().unTrustCommand, new String[]{username});
    }
}

