/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.SettingType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;

public class BlockExplodeListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockExplode(BlockExplodeEvent event) {
        if (!this.iridiumTeams.getConfiguration().preventTntGriefing) {
            return;
        }
        Optional<Team> currentTeam = this.iridiumTeams.getTeamManager().getTeamViaLocation(event.getBlock().getLocation());
        if (currentTeam.isPresent()) {
            TeamSetting teamSetting = this.iridiumTeams.getTeamManager().getTeamSetting((Team)currentTeam.get(), SettingType.TNT_DAMAGE.getSettingKey());
            if (teamSetting == null) {
                return;
            }
            if (teamSetting.getValue().equalsIgnoreCase("Disabled")) {
                event.setCancelled(true);
                return;
            }
        }
        int currentTeamId = currentTeam.map(Team::getId).orElse(0);
        event.blockList().removeIf(blockState -> {
            Optional<Team> team = this.iridiumTeams.getTeamManager().getTeamViaLocation(blockState.getLocation());
            return team.map(Team::getId).orElse(currentTeamId) != currentTeamId;
        });
    }

    @Generated
    public BlockExplodeListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

