/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.google.common.collect.ImmutableMap;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class BlockPistonListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;
    private static final Map<BlockFace, int[]> offsets = ImmutableMap.builder().put((Object)BlockFace.EAST, (Object)new int[]{1, 0, 0}).put((Object)BlockFace.WEST, (Object)new int[]{-1, 0, 0}).put((Object)BlockFace.UP, (Object)new int[]{0, 1, 0}).put((Object)BlockFace.DOWN, (Object)new int[]{0, -1, 0}).put((Object)BlockFace.SOUTH, (Object)new int[]{0, 0, 1}).put((Object)BlockFace.NORTH, (Object)new int[]{0, 0, -1}).build();

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        Optional<Team> team = this.iridiumTeams.getTeamManager().getTeamViaLocation(event.getBlock().getLocation());
        int currentTeam = team.map(Team::getId).orElse(0);
        for (Block block : event.getBlocks()) {
            int[] offset = offsets.get(event.getDirection());
            Optional<Team> newTeam = this.iridiumTeams.getTeamManager().getTeamViaLocation(block.getLocation().add((double)offset[0], (double)offset[1], (double)offset[2]), team);
            if (newTeam.map(Team::getId).orElse(0) == currentTeam) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Optional<Team> team = this.iridiumTeams.getTeamManager().getTeamViaLocation(event.getBlock().getLocation());
        int currentTeam = team.map(Team::getId).orElse(0);
        for (Block block : event.getBlocks()) {
            Optional<Team> newTeam = this.iridiumTeams.getTeamManager().getTeamViaLocation(block.getLocation(), team);
            if (newTeam.map(Team::getId).orElse(0) == currentTeam) continue;
            event.setCancelled(true);
            return;
        }
    }

    @Generated
    public BlockPistonListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

