/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBlock;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSpawners;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockPlaceListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.iridiumTeams.getTeamManager().isBankItem(event.getItemInHand())) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        Optional<T> team = this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(player, event.getBlock().getLocation());
        if (team.isPresent()) {
            if (!this.iridiumTeams.getTeamManager().getTeamPermission((Team)team.get(), user, PermissionType.BLOCK_PLACE)) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotPlaceBlocks.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                event.setCancelled(true);
            }
        } else {
            this.iridiumTeams.getTeamManager().handleBlockPlaceOutsideTerritory(event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void monitorBlockPlace(BlockPlaceEvent event) {
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)event.getPlayer());
        XMaterial material = XMaterial.matchXMaterial(event.getBlock().getType());
        this.iridiumTeams.getTeamManager().getTeamViaID(((IridiumUser)user).getTeamID()).ifPresent(team -> this.iridiumTeams.getMissionManager().handleMissionUpdate((Team)team, event.getBlock().getLocation().getWorld(), "PLACE", material.name(), 1));
        this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(event.getPlayer(), event.getBlock().getLocation()).ifPresent(team -> {
            TeamBlock teamBlock = this.iridiumTeams.getTeamManager().getTeamBlock((Team)team, material);
            teamBlock.setAmount(teamBlock.getAmount() + 1);
            if (event.getBlock().getState() instanceof CreatureSpawner) {
                CreatureSpawner creatureSpawner = (CreatureSpawner)event.getBlock().getState();
                if (creatureSpawner.getSpawnedType() == null) {
                    return;
                }
                TeamSpawners teamSpawners = this.iridiumTeams.getTeamManager().getTeamSpawners((Team)team, creatureSpawner.getSpawnedType());
                teamSpawners.setAmount(teamSpawners.getAmount() + 1);
            }
        });
    }

    @Generated
    public BlockPlaceListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

