/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.SettingType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.metadata.MetadataValue;

public class EntityExplodeListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.iridiumTeams.getConfiguration().preventTntGriefing) {
            return;
        }
        List list = event.getEntity().getMetadata("team_spawned");
        Optional<T> currentTeam = this.iridiumTeams.getTeamManager().getTeamViaLocation(event.getEntity().getLocation());
        if (currentTeam.isPresent()) {
            boolean isEntityGriefDisabled;
            TeamSetting tntDisabled = this.iridiumTeams.getTeamManager().getTeamSetting((Team)currentTeam.get(), SettingType.TNT_DAMAGE.getSettingKey());
            TeamSetting entityGriefDisabled = this.iridiumTeams.getTeamManager().getTeamSetting((Team)currentTeam.get(), SettingType.ENTITY_GRIEF.getSettingKey());
            if (tntDisabled == null && entityGriefDisabled == null) {
                return;
            }
            boolean isTnTDisabled = tntDisabled != null && tntDisabled.getValue().equalsIgnoreCase("Disabled");
            boolean bl = isEntityGriefDisabled = entityGriefDisabled != null && entityGriefDisabled.getValue().equalsIgnoreCase("Disabled");
            if (isTnTDisabled || isEntityGriefDisabled) {
                event.setCancelled(true);
                return;
            }
        }
        int originalTeamId = list.stream().map(MetadataValue::asInt).findFirst().orElse(0);
        event.blockList().removeIf(blockState -> {
            Optional<Team> team = this.iridiumTeams.getTeamManager().getTeamViaLocation(blockState.getLocation());
            return team.map(Team::getId).orElse(originalTeamId) != originalTeamId;
        });
    }

    @Generated
    public EntityExplodeListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

