/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerTeleportListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        Location to = event.getTo();
        Location from = event.getFrom();
        if (to == null) {
            return;
        }
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        Optional<Team> toTeam = this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(player, to);
        Optional<Team> fromTeam = this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(player, from);
        if (((IridiumUser)user).isFlying() && (to.getBlockX() != from.getBlockX() || to.getBlockZ() != from.getBlockZ()) && !((IridiumUser)user).canFly(this.iridiumTeams)) {
            ((IridiumUser)user).setFlying(false);
            player.setAllowFlight(false);
            player.setFlying(false);
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().flightDisabled.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
        }
        if (!toTeam.isPresent()) {
            return;
        }
        if (!this.iridiumTeams.getTeamManager().canVisit(player, (Team)toTeam.get())) {
            event.setCancelled(true);
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotVisit.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
            return;
        }
        if (!toTeam.map(Team::getId).orElse(-1).equals(fromTeam.map(Team::getId).orElse(-1))) {
            this.iridiumTeams.getTeamManager().sendTeamTitle(player, (Team)toTeam.get());
        }
    }

    @Generated
    public PlayerTeleportListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

